%define qt4_bindir %{_libdir}/qt4/bin

Summary: A mass spectrometry software for (bio-)polymers
Name: massxpert
Version: 1.7.6
Release: 1%{?dist}
#Epoch: 1
License: GPLv2+
Group: Applications/Science
Source0: http://www.massxpert.org/downloads/source/%{name}-%{version}.tar.gz
URL: http://massxpert.org/

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: cmake
BuildRequires: desktop-file-utils
BuildRequires: qt4-devel

%define builddir /usr/src/redhat/BUILD/%{name}-%{version}
%define cmakebuilddir %{builddir}/cmakebuild


%description 
massXpert is a mass spectrometry software that allows
simulation of mass spectrometric experiments on (bio-)polymers. The
user defines polymer chemistries and uses the definition to perform
easy mass spectrometric calculations or to perform sophisticated mass
spectrometry simulations on (bio-)polymeric sequences.

%prep
%setup -q
mkdir -p %{cmakebuilddir}

%build
cd %{cmakebuilddir} && %cmake -D CMAKE_INSTALL_PREFIX=/usr ../

make VERBOSE=1 -C %{cmakebuilddir}


%install
%{__rm} -rf %{buildroot}
make -C %{cmakebuilddir} install DESTDIR=%{buildroot}

# install icon file
%{__install} -d %{buildroot}/%{_datadir}/pixmaps
%{__install} -m0644 \
	%{builddir}/gui/images/%{name}-icon-32.xpm \
	%{buildroot}/%{_datadir}/pixmaps/%{name}-icon-32.xpm

%clean
%{__rm} -rf %{buildroot}
%{__rm} -rf %{cmakebuilddir}


%files
%defattr(-, root, root, -)
%{_bindir}/%{name}

%dir %{_libdir}/%{name}/plugins
%{_libdir}/%{name}/plugins/*.so

%dir %{_datadir}
%{_datadir}/pixmaps/%{name}-icon-32.xpm
%{_datadir}/applications/%{name}.desktop

%dir %{_datadir}/%{name}
%{_datadir}/%{name}/chem_pad.conf
%{_datadir}/%{name}/protein-1-to-3.dic
%{_datadir}/%{name}/protein-3-to-1.dic

%dir %{_datadir}/%{name}/locales
%{_datadir}/%{name}/locales/*

%dir %{_datadir}/%{name}/pol-chem-defs
%{_datadir}/%{name}/pol-chem-defs/*

%dir %{_datadir}/%{name}/pol-seqs
%{_datadir}/%{name}/pol-seqs/*

%dir %{_datadir}/doc/%{name}
%{_datadir}/doc/%{name}/COPYING

%dir %{_mandir}/man1
%{_mandir}/man1/*

%dir %{_mandir}/man7
%{_mandir}/man7/*

%dir %{_datadir}/doc/%{name}/usermanual
%{_datadir}/doc/%{name}/usermanual/*


%changelog
* Sun Mar 30 2008 rusconi <massxpert-maintainer@massxpert.org> - 1:1.7.3-1
- New upstream release. Version 1.7.3-1

* Wed Mar 19 2008 rusconi <massxpert-maintainer@massxpert.org> - 1:1.7.1-1
- New upstream release. Version 1.7.1-1

* Fri Feb 22 2008 rusconi <rusconi@filo> - 1:1.7.0-1
- New upstream release. Version 1.7.0-1

* Fri Feb 15 2008 rusconi <rusconi@filo> - 1:1.6.9-1
- New upstream release. Version 1.6.9-1

* Sat Dec 15 2007 Filippo Rusconi <massxpert-maintainer@massxpert.org> 1.6.8-1

- Initial RPM release.

