/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef ISOTOPIC_CURVE_HPP
#define ISOTOPIC_CURVE_HPP

#include <QList>

#include "globals.hpp"
#include "isotopicPeak.hpp"


namespace massXpert
{

  class IsotopicCurve
  {
  private:
    // Each curve (x,y) pair is actually an IsotopicPeak.
    QList<IsotopicPeak *>m_isotopicPeakList;
  
    double m_mzRatio;
    double m_intensity;
  
    double m_fwhm;
    double m_resolution;

    int m_points;
    double m_increment;
    double m_normFactor;
    CurveType m_curveType ;

  public:
    IsotopicCurve();
    IsotopicCurve(double /* mzRatio */, double /* intensity */, 
                  double /* fwhm */,
                  int /* points */, float /* increment */,
                  double /* normFactor */, CurveType /* curveType */);
    IsotopicCurve(const IsotopicCurve &);
    ~IsotopicCurve();

    const QList<IsotopicPeak *> &isotopicPeakList() const;
  
    void appendPeak(IsotopicPeak *);
    void emptyPeakList();
            
    void setMzRatio(double);
    double mzRatio();
    QString mzRatioString();
    
    void setIntensity(double);
    double intensity();
    QString intensityString();

    void setFwhm(double);
    double fwhm();
    QString fwhmString();

    void setPoints(int);
    int points();
    QString pointsString();
      
    // For the lorentzian, that is half of the fwhm.
    double hwhm();
    QString hwhmString();
  
    double a();
    QString aString();
  
    double c();
    QString cString();

    double gamma();
    QString gammaString();

    void setIncrement(double);
    double increment();
    QString incrementString();

    QString config();
      
    int calculateCurve();
    int calculateGaussianCurve();
    int calculateLorentzianCurve();

    double intensityAt(double, double, bool *);

    QString dataAsString();
    bool dataToFile(QString);
  } ;

} // namespace massXpert

#endif // ISOTOPIC_CURVE_HPP
