#include "mbdesktop_module.h"
#include <glob.h>

typedef struct BrowserData { 
  char* BrowserCurrentPath;
  char* BrowserPath;
  char* BrowserMatchStr;
  char* BrowserIcon;
  char* BrowserExecWith;
  char* BrowserFolderName;
  char* BrowserFolderIcon;
} BrowserData;

static void
filebrowser_file_activate_cb (void *data1, void *data2)
{
  BrowserData *mod_data;
  MBDesktop *mb = (MBDesktop *)data1; 
  MBDesktopItem *item = (MBDesktopItem *)data2; 
  char *exec_str = NULL;

  mod_data = (BrowserData*)mbdesktop_module_get_userdata_from_item (mb, item );

  exec_str = alloca(strlen(mod_data->BrowserExecWith)+strlen(mod_data->BrowserPath)+strlen(item->name)+6);

  sprintf(exec_str, "%s %s/%s", mod_data->BrowserExecWith, mod_data->BrowserPath, item->name);

  switch (fork())
    {
    case 0:
      mb_exec(exec_str);
      fprintf(stderr, "exec failed, cleaning up child\n");
      exit(1);
    case -1:
      fprintf(stderr, "can't fork\n");
      break;
    }
}

MBDesktopItem *
filebrowser_init (MBDesktop             *mb, 
		  MBDesktopFolderModule *folder_module, 
		  char                  *arg_str)
{
  MBDesktopItem *folder_result = NULL;
  BrowserData   *mod_data = NULL;

  char *p = NULL, *q = NULL, *key = NULL, *val = NULL;

  if (!arg_str)
    {
      fprintf(stderr, "mbdesktop: simplefilebrowser module missing args\n");
      return NULL;
    }

  mod_data = malloc(sizeof(BrowserData));
  //memset(mod_data, 0, sizeof(BrowserData));

  /* Defualts */
  mod_data->BrowserMatchStr    = "*"; 
  mod_data->BrowserIcon        = "mbnoapp.png"; 
  mod_data->BrowserExecWith    = "cat"; 
  mod_data->BrowserFolderName  = "files"; 
  mod_data->BrowserFolderIcon  = "mbfolder.png"; 

  if ((strchr(arg_str, '=') != NULL))
    {
      p = arg_str;

      while ( *p != '\0' )
	{
	  if ((q = strchr(p, ',')) != NULL) /* XXX *.{mpg,mpeg,avi,wmv,asf} */
	    *q = '\0';
	  else 
	    q = p + strlen(p) - 1;

	  if ( (val = strchr(p, '=')) != NULL)
	    {
	      *val++ = '\0'; key = p;
	      
	      if (!strcmp("path", key))
		mod_data->BrowserPath = strdup(val);
	      else if (!strcmp("match", key))
		{
		  mod_data->BrowserMatchStr = strdup(val);
		}
	      else if (!strcmp("icon", key))
		mod_data->BrowserIcon = strdup(val);
	      else if (!strcmp("exec", key))
		mod_data->BrowserExecWith = strdup(val);
	      else if (!strcmp("foldername", key))
		mod_data->BrowserFolderName = strdup(val);
	      else if (!strcmp("foldericon", key))
		mod_data->BrowserFolderIcon = strdup(val);
	      else
		fprintf(stderr, 
			"mbdesktop: simplefilebrowser dont know key %s\n",
			key);
	    } 
	  p = q + 1;
	}
    }
  else mod_data->BrowserPath = strdup(arg_str); 

  if (mod_data->BrowserPath == NULL)
    {
      fprintf(stderr, "mbdesktop: simplefilebrowser module missing path\n");
      return NULL;
    }      
  
  mbdesktop_module_set_userdata(mb, folder_module, (void *)mod_data);

  folder_result = mbdesktop_module_folder_create (mb, 
						  mod_data->BrowserFolderName, 
						  mod_data->BrowserFolderIcon );
  folder_result->item_parent->view = VIEW_LIST;

  return folder_result;
}

void
filebrowser_open (MBDesktop *mb, MBDesktopItem *item_folder)
{
  DIR *dp;
  BrowserData   *mod_data;

  char   orig_wd[256];
  glob_t globbuf;	  
  int    i;

  MBDesktopItem *item_new = NULL; 

  mod_data = (BrowserData*)mbdesktop_module_get_userdata_from_item (mb, item_folder);

  if ((dp = opendir(mod_data->BrowserPath)) == NULL)
    {
      fprintf(stderr, "failed to open %s\n", mod_data->BrowserPath);
      return;
    }
  
  if (getcwd(orig_wd, 255) == (char *)NULL)
    {
      fprintf(stderr, "mbmenu: cant get current directory\n");
      exit(0);
    }

  chdir(mod_data->BrowserPath);

  globbuf.gl_offs = 0;

  glob(mod_data->BrowserMatchStr, GLOB_DOOFFS, NULL, &globbuf);

  for(i=0; i < globbuf.gl_pathc; i++)
    {
      item_new = mbdesktop_item_new_with_params( mb,
						 globbuf.gl_pathv[i],
						 mod_data->BrowserIcon,
						 NULL,
						 ITEM_TYPE_MODULE_ITEM
						 );

      mbdesktop_item_set_activate_callback (mb, item_new, 
					    filebrowser_file_activate_cb); 
      
      mbdesktop_items_append_to_folder( mb, item_folder, item_new );
    }

  globfree(&globbuf);

  /*
  while((dir_entry = readdir(dp)) != NULL)
    {
      lstat(dir_entry->d_name, &stat_info);
      if (!(S_ISDIR(stat_info.st_mode)))
	{
	  item_new = mbdesktop_item_new_with_params( mb,
						     dir_entry->d_name,
						     "mbnoapp.png",
					             NULL,
						     ITEM_TYPE_MODULE_ITEM
						     );
	  mbdesktop_item_set_activate_callback (mb, item_new, 
						filebrowser_file_activate_cb); 
  
	  mbdesktop_items_append_to_folder( mb, item_folder, item_new );
	}
    }
  */

  closedir(dp);

  chdir(orig_wd);

}

void
filebrowser_close (MBDesktop     *mb, 
		   MBDesktopItem *item_folder)
{
  mbdesktop_item_folder_contents_free(mb, item_folder); 
}


#define MODULE_NAME         "simple file system browser"
#define MODULE_DESC         "simple file system browser"
#define MODULE_AUTHOR       "Matthew Allum"
#define MODULE_MAJOR_VER    0
#define MODULE_MINOR_VER    0
#define MODULE_MICRO_VER    1
#define MODULE_API_VERSION  0
 
MBDesktopModuleInfo filebrowser_info = 
  {
    MODULE_NAME         ,
    MODULE_DESC         ,
    MODULE_AUTHOR       ,
    MODULE_MAJOR_VER    ,
    MODULE_MINOR_VER    ,
    MODULE_MICRO_VER    ,
    MODULE_API_VERSION
  };

MBDesktopFolderModule folder_module =
  {
    &filebrowser_info,
    filebrowser_init,
    filebrowser_open,
    filebrowser_close, 
    NULL,
    NULL
  };
