#include "msg.h"

static void
msg_calc_win_size(MBPanel *d, MBPanelMessageQueue *m, int *w, int *h);

static
void msg_shape_balloon(MBPanel *d, int fx, int width, int height, Bool flip);

static int
_get_text_length(MBPanel *d, char *str, int cnt)
{
#ifdef USE_XFT
   XGlyphInfo extents;
   XftTextExtents8(d->dpy, d->msg_font, (unsigned char *) str,
		   cnt, &extents);
   return extents.width;
#else
   return XTextWidth(d->msg_font, str, cnt);
#endif
}

static unsigned long 
_get_server_time(MBPanel *d)
{
  XEvent xevent;
  char c = 'a';

  XChangeProperty (d->dpy, d->win_root, 
		   d->atoms[ATOM_MB_DOCK_TIMESTAMP],
		   d->atoms[ATOM_MB_DOCK_TIMESTAMP], 
		   8, PropModeReplace, &c, 1);
  DBG("%s() : getting server time\n", __func__);

  for (;;) {
    XMaskEvent(d->dpy, PropertyChangeMask, &xevent);
    if (xevent.xproperty.atom == d->atoms[ATOM_MB_DOCK_TIMESTAMP])
      {
	  return xevent.xproperty.time;
      }
  }
}


MBPanelMessageQueue*
msg_new(MBPanel *dock, XClientMessageEvent *e)
{
   MBPanelMessageQueue *m;
   MBPanelApp *sender;

   if ((sender = panel_app_get_from_window(dock, e->window )) == NULL)
      return NULL;

   m = (MBPanelMessageQueue *)malloc(sizeof(MBPanelMessageQueue));
   m->sender = sender;

   m->starttime = e->data.l[0];
   m->timeout   = e->data.l[2];

   m->total_msg_length = e->data.l[3];
   m->id = e->data.l[4];
   m->data = (unsigned char *)malloc(sizeof(unsigned char)
				     *(m->total_msg_length+1));
   m->current_msg_length = 0;
   m->pending = False;
   m->next = NULL;
   
   if (dock->msg_queue_start == NULL)
   {
      DBG("queue is empty\n");
      dock->msg_queue_start = dock->msg_queue_end = m;
   } else {
      DBG("queue is not empty\n");
      dock->msg_queue_end->next = m;
      dock->msg_queue_end = m;
   }
   
   return m;
}

void
msg_destroy(MBPanel *d, MBPanelMessageQueue *m)
{
   MBPanelMessageQueue *q;
   if (d->msg_queue_start == m)
   {
      d->msg_queue_start = m->next;
   } else {
      for(q=d->msg_queue_start; q->next != NULL; q=q->next)
      {
	 if (q->next == m)
	 {
	    q->next = m->next;
	    break;
	 }
      }
   }
   free(m->data);
   free(m);
}

void
msg_add_data(MBPanel *d, XClientMessageEvent *e)
{
   MBPanelMessageQueue *m;

   for(m=d->msg_queue_start; m != NULL; m=m->next)
   {
      if (m->sender->win == e->window)
      {
	 if ( (m->total_msg_length - m->current_msg_length) > 20)
	 {
	    memcpy(&m->data[m->current_msg_length],e->data.b,sizeof(char)*20);
	    m->current_msg_length += 20;
	 } else {
	    memcpy(&m->data[m->current_msg_length],e->data.b,
		   (m->total_msg_length-m->current_msg_length) );
	    m->current_msg_length = m->total_msg_length;
	    m->data[m->total_msg_length] = '\0';
	
	    m->pending = True;
	 }
	 return;
      }
   }
}

void
msg_handle_events(MBPanel *d, XEvent *e)
{
   MBPanelMessageQueue *m = NULL;

   for(m=d->msg_queue_start; m != NULL; m=m->next)
   {
      if (m->pending)
      {
	 int w = 0, h = 0, i = 0, fh;
	 int wx, wy, fx = 0, fy;
	 Bool flip = False;
	 Pixmap tmp_pxmp;
	 XSetWindowAttributes attr;
	 XWindowAttributes root_attr;
	 XWMHints *wm_hints;
	 char *q, *p = m->data;
	 long winmask;
#ifdef USE_XFT
	 
	 XftDraw *xftdraw;
	 
#endif
	 if (d->msg_win)
	 {
	    XDestroyWindow(d->dpy, d->msg_win);
	    d->msg_win = None;
	 }
	 
	 msg_calc_win_size(d, m, &w, &h);

	 XGetWindowAttributes(d->dpy, d->win_root, &root_attr);

	 w += (2*MSG_WIN_X_PAD);
	 h += (2*MSG_WIN_Y_PAD) + MSG_BUB_POLY;

	 if (PANEL_IS_VERTICAL(d))
	   {
	     if (d->orientation == East)
	       wx = d->x - w - 5;
	     else
	       wx = d->x + d->w + 5;

	     wy = m->sender->y -25 ;

	     fy = wy;

	   } else {
	     wx = m->sender->x - 25;
	     if ((wx+w) > d->w) wx -= ((wx+w)-d->w);
	     if (wx < 0) wx = m->sender->x;
	     
	     fx = (m->sender->x+(m->sender->w/2)) - wx;
	     
	     wy = d->y + d->h + 5;
	     if ((wy+h) > root_attr.height)
	       {
		 wy -= (h + d->h + 10);
		 flip = True;
	       }
	     fy = wy;
	   }

	 d->msg_starttime  = m->starttime;
	 d->msg_timeout    = m->timeout; 
	 d->msg_win_sender = m->sender;
	 
	 attr.event_mask = ButtonPressMask|ButtonReleaseMask|ExposureMask;
	 attr.background_pixel = d->msg_xcol.pixel;
	 attr.do_not_propagate_mask = ButtonPressMask|ButtonReleaseMask;
	 winmask = CWBackPixel|CWEventMask|CWDontPropagate;
	 if (d->use_overide_wins)
	   {
	     winmask |= CWOverrideRedirect;
	     attr.override_redirect = True;
	   }

	 d->msg_win = XCreateWindow(d->dpy, d->win_root,
				    wx,
				    wy, w, h, 0,
				    CopyFromParent,
				    CopyFromParent,
				    CopyFromParent,
				    winmask,
				    &attr);

	 XChangeProperty(d->dpy, d->msg_win, d->atoms[ATOM_WM_WINDOW_TYPE],
			 XA_ATOM, 32,  PropModeReplace,
			 (unsigned char *)
			 &d->atoms[ATOM_WM_WINDOW_TYPE_SPLASH], 1);

	 wm_hints = XAllocWMHints();
	 wm_hints->input = False;
	 wm_hints->flags = InputHint;
	 XSetWMHints(d->dpy, d->msg_win, wm_hints );


		
	 tmp_pxmp = XCreatePixmap(d->dpy, d->msg_win, w, h,
				  DefaultDepth(d->dpy, d->screen));

	 if (m->timeout)
	   XSetForeground(d->dpy, d->msg_gc, d->msg_xcol.pixel);
	 else
	   XSetForeground(d->dpy, d->msg_gc, d->msg_urgent_xcol.pixel);

	 XFillRectangle(d->dpy, tmp_pxmp, d->msg_gc, 0, 0, w, h); 
	 XSetForeground(d->dpy, d->msg_gc, BlackPixel(d->dpy, d->screen));

#ifdef USE_XFT
	 xftdraw = XftDrawCreate(d->dpy, (Drawable) tmp_pxmp, 
				 DefaultVisual(d->dpy, d->screen),
				 DefaultColormap(d->dpy, d->screen));
#endif

	 fh = d->msg_font->ascent + MSG_WIN_Y_PAD + MSG_BUB_POLY;
	 if (flip) fh -= MSG_BUB_POLY;

	 i = strlen(m->sender->name);
	 while (_get_text_length(d, m->sender->name, i) > (w-30) && i > 0)
	   i--;

#ifdef USE_XFT
	 XftDrawString8(xftdraw, &(d->fg_xftcol), d->msg_font, 
			10, fh, 
			(unsigned char *)m->sender->name, i);
#else
	 XDrawString(d->dpy, tmp_pxmp, d->msg_gc, 10, fh,
		     m->sender->name, i);
#endif
	 
	 XDrawRectangle(d->dpy, tmp_pxmp, d->msg_gc, w-15, 
		   fh - d->msg_font->ascent - 2, 
			d->msg_font_height, d->msg_font_height );

	 XDrawLine(d->dpy, tmp_pxmp, d->msg_gc, w-15, 
		   fh - d->msg_font->ascent - 2,
		   w-15 + d->msg_font_height,
		   fh - d->msg_font->ascent - 2 + d->msg_font_height);

	 XDrawLine(d->dpy, tmp_pxmp, d->msg_gc, w-15, 
		   fh - d->msg_font->ascent - 2 + d->msg_font_height,
		   w-15 + d->msg_font_height,
		   fh - d->msg_font->ascent - 2 );


	 XDrawLine(d->dpy, tmp_pxmp, d->msg_gc,
		   5, fh+d->msg_font->descent+2, 
		   w-5, fh+d->msg_font->descent+2);
 
	 fh += d->msg_font_height+5;

	 while( *p != '\0' )
	 {
	    q = p;
	    while( *p != '\n' && *p != '\0' ) p++;
	    if (*p == '\n') { *p = '\0'; p++; }
#ifdef USE_XFT
	    XftDrawString8(xftdraw, &(d->fg_xftcol), d->msg_font, MSG_WIN_X_PAD,
			   fh, (unsigned char *)q, strlen(q));
#else
	    XDrawString(d->dpy, tmp_pxmp, d->msg_gc, MSG_WIN_X_PAD,
			fh, q, strlen(q));
#endif
	    fh += d->msg_font_height;
	 }
	 
	 
	 XSetWindowBackgroundPixmap(d->dpy, d->msg_win, tmp_pxmp);
#ifdef USE_XFT
	 XftDrawDestroy(xftdraw);
#endif
	 XFreePixmap(d->dpy, tmp_pxmp);
	 
	 msg_shape_balloon(d, fx, w , h, flip); 

	 XMapWindow(d->dpy, d->msg_win);
	 XFree(wm_hints);


	 msg_destroy(d, m);
	 return;
      }
   }

   if (d->msg_win)
   {
     switch (e->type)
       {
       case Expose:
	 break;
       case ButtonRelease:
	 if ( e->xbutton.window == d->msg_win)
	   {
	     XDestroyWindow(d->dpy, d->msg_win);
	     d->msg_win = None;
	   }
	 break;
       }
   }
}

void
msg_handle_timeouts(MBPanel *d)
{
   if (d->msg_win)
   {
     if (d->msg_timeout) 	/* NON ZERO */
       {
	 if ((d->msg_starttime+d->msg_timeout) < _get_server_time(d))
	   {
	       XDestroyWindow(d->dpy, d->msg_win);
	       d->msg_win = None;
	       return;
	   }
       }
   }
}

static void
msg_calc_win_size(MBPanel *d, MBPanelMessageQueue *m, int *w, int *h)
{
   char *q, *p = m->data;
   int cnt = 0;
   int title_width = 0;
   *w = 0;
   *h = 0;
   
   while( *p != '\0' )
   {
      cnt = 0;
      q = p;
      while( *p != '\n' && *p != '\0' ) { p++; cnt++; } 
      
      if (_get_text_length(d, q, cnt) > *w)
	*w = _get_text_length(d, q, cnt);
      *h += d->msg_font_height;
      if (*p == '\n') p++; 
   }
   *h += d->msg_font_height + 5; /* title + line */

   title_width = _get_text_length(d, m->sender->name, 
				  strlen(m->sender->name)) + 15;
   if (title_width > *w) *w = title_width;
}


static
void msg_shape_balloon(MBPanel *d, int fx, int width, int height, Bool flip)
{
   XPoint tri[3];
   Pixmap mask;
   GC ShapeGC;
   int hoff = MSG_BUB_POLY ;
   
   mask = XCreatePixmap( d->dpy, d->win_root, width, height, 1 );
   ShapeGC = XCreateGC( d->dpy, mask, 0, 0 );
   
   XSetForeground( d->dpy, ShapeGC, BlackPixel( d->dpy, d->screen ));
   XFillRectangle( d->dpy, mask, ShapeGC, 0, 0, width, height );
   XSetForeground( d->dpy, ShapeGC, WhitePixel( d->dpy, d->screen ));
   XSetBackground( d->dpy, ShapeGC, BlackPixel( d->dpy, d->screen ));

   if (flip)
   {
      XFillRectangle(d->dpy, mask, ShapeGC, 10, 0, width-20, height-hoff);
      XFillRectangle(d->dpy, mask, ShapeGC, 0, 10, width, height-hoff-20);

      XFillArc( d->dpy, mask, ShapeGC, 0, 0, 21, 21, 90*64, 90*64 );
      XFillArc( d->dpy, mask, ShapeGC, width-21, 0, 21, 21, 0, 90*64 );

      if ( (fx+hoff) > width)
	XFillRectangle( d->dpy, mask, ShapeGC, width-21, height-21-hoff,
			21, 21);
      else
	XFillArc( d->dpy, mask, ShapeGC, width-21, height-21-hoff,
		  21, 21, 270*64, 90*64 );

      if ( (fx-hoff) < 0 )
	XFillRectangle( d->dpy, mask, ShapeGC, 0, height-21-hoff,
			21, 21);
      else
	XFillArc( d->dpy, mask, ShapeGC, 0, height-21-hoff,
		  21, 21, 180*64, 90*64 );

      tri[0].x = fx;	        tri[0].y = height;
      tri[1].x = fx+hoff;	tri[1].y = height-hoff;
      tri[2].x = fx-hoff;	tri[2].y = height-hoff;;

   } else {
      XFillRectangle(d->dpy, mask, ShapeGC, 10, hoff, width-20, height-hoff);
      XFillRectangle(d->dpy, mask, ShapeGC, 0, hoff+10, width, height-hoff-20);
      
      XFillArc( d->dpy, mask, ShapeGC, 0, hoff, 21, 21, 90*64, 90*64 );
      XFillArc( d->dpy, mask, ShapeGC, width-21, hoff, 21, 21, 0, 90*64 );
      XFillArc( d->dpy, mask, ShapeGC, width-21, height-21,
		21, 21, 270*64, 90*64 );
      XFillArc( d->dpy, mask, ShapeGC, 0, height-21, 21, 21, 180*64, 90*64 );
      
      tri[0].x = fx;	        tri[0].y = 0;
      tri[1].x = fx+hoff;       tri[1].y = hoff;
      tri[2].x = fx-hoff;	tri[2].y = hoff;
   }

   if (!PANEL_IS_VERTICAL(d))
     XFillPolygon( d->dpy, mask, ShapeGC, tri, 3, Nonconvex, CoordModeOrigin );
   
   XShapeCombineMask( d->dpy, d->msg_win, ShapeBounding, 0, 0, mask, ShapeSet);
   
   XFreePixmap( d->dpy, mask );
   XFreeGC( d->dpy, ShapeGC );
}

