/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "mbtheme-standalone.h"

static void
_draw_cross(MBTheme *theme, Drawable drw, int size, int state)
{
  Pixmap pxm_backing;

  dbg("%s() called \n", __func__);

  pxm_backing = XCreatePixmap(theme->wm->dpy, theme->wm->root, size, size, 
			      DefaultDepth(theme->wm->dpy, theme->wm->screen));

  XSetFunction(theme->wm->dpy, theme->gc, GXcopy);
  XSetForeground(theme->wm->dpy, theme->gc, theme->col_bg.pixel);
  XFillRectangle(theme->wm->dpy, pxm_backing, theme->gc, 0, 0, size, size);

  XSetLineAttributes(theme->wm->dpy, theme->gc, THEME_LINE_WIDTH, 
		     LineSolid, CapRound, JoinRound);

  if (state == ACTIVE)
    XSetFunction(theme->wm->dpy, theme->gc, GXcopyInverted);

  size--;

  XSetForeground(theme->wm->dpy, theme->gc, theme->col_fg.pixel);
  XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, 0, 0, size, size);
  XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, size, 0, 0, size);

  XSetWindowBackgroundPixmap(theme->wm->dpy, drw, pxm_backing);
  XClearWindow(theme->wm->dpy, drw);   

  XFlush(theme->wm->dpy);

  XFreePixmap(theme->wm->dpy, pxm_backing);
}

static void
_draw_arrow(MBTheme *theme, Drawable drw, int w, int h, int action, int state)
{
  Pixmap pxm_backing;

  dbg("%s() called \n", __func__);

  pxm_backing = XCreatePixmap(theme->wm->dpy, theme->wm->root, w, h, 
			      DefaultDepth(theme->wm->dpy, theme->wm->screen));

  XSetFunction(theme->wm->dpy, theme->gc, GXcopy);
  XSetForeground(theme->wm->dpy, theme->gc, theme->col_bg.pixel);
  XFillRectangle(theme->wm->dpy, pxm_backing, theme->gc, 0, 0, w, h);

  XSetForeground(theme->wm->dpy, theme->gc, theme->col_fg.pixel);

  XSetLineAttributes(theme->wm->dpy, theme->gc, THEME_LINE_WIDTH, 
		     LineSolid, CapRound, JoinRound);

  if (state == ACTIVE)
    XSetFunction(theme->wm->dpy, theme->gc, GXcopyInverted);

  h--; w--;

  if (action == BUTTON_ACTION_NEXT )
    {
      XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, 0, 0, w, h/2);
      XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, 0, h, w, h/2);
    }
  else /* BUTTON_ACTION_PREV */
    {
      XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, w, 0, 0, h/2);
      XDrawLine(theme->wm->dpy, pxm_backing, theme->gc, w, h, 0, h/2);
    }

  XSetWindowBackgroundPixmap(theme->wm->dpy, drw, pxm_backing);
  XClearWindow(theme->wm->dpy, drw);   

  XFlush(theme->wm->dpy);

  XFreePixmap(theme->wm->dpy, pxm_backing);
}


void
theme_paint_rgba_icon(MBTheme *t, Client *c, 
		      Drawable drw, int x, int y, 
		      int *data)
{
  return;
}

void theme_frame_icon_paint(MBTheme *t, 
			    Client *c, 
			    MBPixbufImage *img_dest, 
			    int x, int y)
{
  return;
}

Bool theme_frame_wants_shaped_window( MBTheme *theme, int frame_type)
{
  return False;
}

Bool theme_frame_supports_button_type(MBTheme *theme, 
				      int frame_type, 
				      int button_type)
{
  return True; 			/* XXX ? */
}

int theme_frame_defined_width_get( MBTheme *theme, int frame_type )
{
  if (frame_type == FRAME_UTILITY_MAX) return FRAME_TOOLBAR_MAX_SIZE;
  if (frame_type == FRAME_DIALOG_EAST || frame_type == FRAME_DIALOG_WEST)
    return FRAME_DIALOG_BORDER_SIZE;
  return 0;
}

int theme_frame_defined_height_get( MBTheme *theme, int frame_type )
{
  switch (frame_type)
    {
    case FRAME_MAIN:
      return FRAME_MAIN_HEIGHT;
    case FRAME_DIALOG:
      return FRAME_DIALOG_HEIGHT;
    case FRAME_UTILITY_MIN:
      return FRAME_TOOLBAR_MIN_SIZE;
    case FRAME_DIALOG_SOUTH:
      return FRAME_DIALOG_BORDER_SIZE;
    }
  return 0;
}

Bool
theme_has_frame_type_defined (MBTheme      *theme, 
			      int           frame_type)
{
  switch (frame_type)
    {
    case FRAME_MAIN:
    case FRAME_MAIN_EAST:
    case FRAME_MAIN_WEST:
    case FRAME_MAIN_SOUTH:
    case FRAME_DIALOG:
    case FRAME_UTILITY_MAX:
    case FRAME_UTILITY_MIN:
    case FRAME_DIALOG_NORTH:
    case FRAME_DIALOG_EAST:
    case FRAME_DIALOG_WEST:
    case FRAME_DIALOG_SOUTH:
      return True;
    }
  return False;
}

void 
theme_img_cache_clear( MBTheme *theme,  int frame_ref )
{
  return;
}

void 
theme_img_cache_clear_all( MBTheme *theme )
{
  return;
}

void theme_frame_button_paint(MBTheme *theme, 
			      Client  *c, 
			      int      action,
			      int      state, 
			      int      frame_type, 
			      int      dest_w, 
			      int      dest_h )
{
  
  MBClientButton *button = NULL;

  struct list_item* client_button_obj = c->buttons;

  while (client_button_obj != NULL)
    {
      if (client_button_obj->id == action) 
	{
	  button = (MBClientButton*)client_button_obj->data;
	  break;
	}
      client_button_obj = client_button_obj->next;
    }


  switch(frame_type)
    {
      case FRAME_MAIN:
	switch (action)
	  {

	  case BUTTON_ACTION_CLOSE:
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    dest_w - FRAME_MAIN_HEIGHT,
					    2,
					    FRAME_MAIN_HEIGHT - 4, 
					    FRAME_MAIN_HEIGHT - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_cross(theme, button->win, FRAME_MAIN_HEIGHT - 4, state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	    break;
	  case BUTTON_ACTION_NEXT:
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    2 + FRAME_MAIN_HEIGHT,
					    2,
					    FRAME_MAIN_HEIGHT - 4, 
					    FRAME_MAIN_HEIGHT - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_arrow(theme, button->win, 
			FRAME_MAIN_HEIGHT - 4, FRAME_MAIN_HEIGHT - 4, 
			BUTTON_ACTION_NEXT, state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	    break;
	  case BUTTON_ACTION_PREV:
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    2,
					    2,
					    FRAME_MAIN_HEIGHT - 4, 
					    FRAME_MAIN_HEIGHT - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_arrow(theme, button->win, FRAME_MAIN_HEIGHT - 4, 
			FRAME_MAIN_HEIGHT - 4, 
			BUTTON_ACTION_PREV, state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	    break;

	  }
      break;
    case FRAME_DIALOG:
	if (action == BUTTON_ACTION_CLOSE)
	  {
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    dest_w - FRAME_MAIN_HEIGHT,
					    2,
					    FRAME_MAIN_HEIGHT - 4, 
					    FRAME_MAIN_HEIGHT - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_cross(theme, button->win, FRAME_MAIN_HEIGHT - 4, state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	  }
	break;
    case FRAME_UTILITY_MAX:
	if (action == BUTTON_ACTION_MIN)
	  {
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    2,
					    2,
					    FRAME_TOOLBAR_MAX_SIZE - 4, 
					    FRAME_TOOLBAR_MAX_SIZE - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_arrow(theme, button->win, 
			FRAME_TOOLBAR_MAX_SIZE - 4, FRAME_TOOLBAR_MAX_SIZE - 4, 
			BUTTON_ACTION_NEXT, state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	  }
	break;
    case FRAME_UTILITY_MIN:
	if (action == BUTTON_ACTION_CLOSE)
	  {
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    dest_w - FRAME_TOOLBAR_MIN_SIZE,
					    2,
					    FRAME_TOOLBAR_MIN_SIZE - 4, 
					    FRAME_TOOLBAR_MIN_SIZE - 4,
					    False,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	    _draw_cross(theme, button->win, FRAME_TOOLBAR_MIN_SIZE - 4, 
			state);
	    dbg("%s() painting close button at %i\n", __func__, dest_w - 20 );
	  }
	else if (action == BUTTON_ACTION_MAX)
	  {
	    if (button == NULL)
	      {
		button = client_button_new (c, 
					    c->title_frame,
					    0,
					    2,
					    dest_w - FRAME_TOOLBAR_MIN_SIZE,
					    dest_h,
					    True,
					    NULL );
		list_add(&c->buttons, NULL, action, (void *)button);
	      }
	  }

	break;
    default: break;
    }

}

Bool theme_frame_paint( MBTheme *theme, 		   
			Client  *c, 
			int frame_ref, 
			int dx,
			int dy, 
			int dw, 
			int dh )
{
  XSetForeground(theme->wm->dpy, theme->gc, theme->col_bg.pixel);
  XFillRectangle(theme->wm->dpy, c->backing, theme->gc, dx, dy, dw, dh);

  if (c->name && ( frame_ref == FRAME_MAIN 
		   || frame_ref == FRAME_DIALOG 
		   || frame_ref == FRAME_UTILITY_MIN ) )
    {
      int xoffset = 0;

#ifdef USE_XFT
      XftFont *font;
#else
      XFontStruct* font;
#endif



      int title_bytes = (c->name_is_utf8) 
	? ewmh_utf8_len(c->name) : strlen(c->name);

      if (frame_ref == FRAME_MAIN) 
	xoffset = (FRAME_MAIN_HEIGHT*2);
      else 
	xoffset = 4;

      if (frame_ref == FRAME_UTILITY_MIN)
	font = theme->font_toolbar;
      else
	font = theme->font;

#ifdef USE_XFT
      if (c->name_is_utf8)
	{

	  XftDrawStringUtf8(c->xftdraw, 
			    &theme->xftcol, 
			    font,
			    xoffset, 
			    font->ascent,
			    (unsigned char *) c->name, 
			    ewmh_utf8_get_byte_cnt(c->name, title_bytes) );
	}
      else XftDrawString8(c->xftdraw, 
			  &theme->xftcol, 
			  font,
			  xoffset, 
			  font->ascent,
			  (unsigned char *) c->name, 
			  title_bytes );

#else
      XSetFont(theme->wm->dpy, theme->gc, font->fid);
      XSetForeground(theme->wm->dpy, theme->gc, theme->col_text.pixel);
      XDrawString(theme->wm->dpy, c->backing, theme->gc, xoffset,
		  font->ascent, c->name, title_bytes);
#endif
    }



  return True;
}

void 
theme_frame_menu_paint(MBTheme* theme, Client *c)
{
  return;
}

Bool 
theme_frame_menu_get_dimentions(MBTheme* theme, int* w, int *h)
{
  return 0;
}

MBTheme* 
mbtheme_new(Wm *w)
{
  XGCValues gv;
#ifdef USE_XFT   
  XRenderColor colortmp;
#endif

  MBTheme *t = (MBTheme *)malloc(sizeof(MBTheme));
  memset(t, 0, sizeof(MBTheme));

  t->wm = w;
  
  gv.graphics_exposures = False;
  gv.function   = GXcopy;
  t->gc = XCreateGC(w->dpy, w->root,
		       GCGraphicsExposures|GCFunction, &gv);
  
  gv.function = GXinvert;
  gv.subwindow_mode = IncludeInferiors;
  gv.line_width = 1;
  t->band_gc = XCreateGC(w->dpy, w->root,
			 GCFunction|GCSubwindowMode|GCLineWidth, &gv);
  
  t->mask_gc = None;

  if (!XParseColor(w->dpy, DefaultColormap(w->dpy, w->screen),
		   THEME_FG_COLOR, &t->col_fg))
    {
      fprintf(stderr, "matchbox: failed to parse color %s\n", THEME_FG_COLOR);
      exit(1);
    } else {
      XAllocColor(w->dpy, DefaultColormap(w->dpy, w->screen), &t->col_fg);
    }

  if (!XParseColor(w->dpy, DefaultColormap(w->dpy, w->screen),
		   THEME_BG_COLOR, &t->col_bg))
    {
      fprintf(stderr, "matchbox: failed to parse color %s\n", THEME_BG_COLOR);
      exit(1);
    } else {
      XAllocColor(w->dpy, DefaultColormap(w->dpy, w->screen), &t->col_bg);
    }

  if (!XParseColor(w->dpy, DefaultColormap(w->dpy, w->screen),
		   THEME_TEXT_COLOR, &t->col_text))
    {
      fprintf(stderr, "matchbox: failed to parse color %s\n", 
	      THEME_TEXT_COLOR);
      exit(1);
    } else {
      XAllocColor(w->dpy, DefaultColormap(w->dpy, w->screen), &t->col_text);
    }

#ifdef USE_XFT      
   colortmp.red   = t->col_text.red;
   colortmp.green = t->col_text.green;
   colortmp.blue  = t->col_text.blue;
   colortmp.alpha = 0xffff; 
   XftColorAllocValue(w->dpy,
		       DefaultVisual(w->dpy, w->screen), 
		       DefaultColormap(w->dpy, w->screen),
		       &colortmp,
		       &t->xftcol);
#endif

#ifdef USE_XFT
  if ((t->font = XftFontOpenName(w->dpy, w->screen, THEME_FONT_MAIN)) 
	    == NULL)
    { 
      fprintf(stderr, "matchbox: failed to load font %s\n", THEME_FONT_MAIN);
      exit(1);
    }
  if ((t->font_toolbar = XftFontOpenName(w->dpy, w->screen, 
					 THEME_FONT_TOOLBAR)) 
	    == NULL)
    { 
      fprintf(stderr, "matchbox: failed to load font %s\n", 
	      THEME_FONT_TOOLBAR);
      exit(1);
    }

#else
      if ((t->font = XLoadQueryFont(t->wm->dpy, THEME_FONT_MAIN)) == NULL)
      {
	fprintf(stderr, "matchbox: failed to load font %s\n", 
		THEME_FONT_TOOLBAR);
	exit(1);
      };
      if ((t->font_toolbar = XLoadQueryFont(t->wm->dpy, THEME_FONT_TOOLBAR)) 
	  == NULL)
      {
	fprintf(stderr, "matchbox: failed to load font %s\n", 
		THEME_FONT_TOOLBAR);
	exit(1);
      };

#endif

  return t;
}


void 
mbtheme_switch(Wm *w, char *new_theme_conf)
{
  return;
}

void 
mbtheme_init(Wm *w, char *theme_conf)
{
  w->mbtheme = mbtheme_new(w);
}

int 
theme_frame_button_get_x_pos(MBTheme *theme, 
			     int frame_type, 
			     int button_type,
			     int width)
{
  return 0;
}


