#!/bin/bash
#
# script which runs through all the window option tests

LOG=winspew.log
rm -f $LOG

# set theme that implements all the required features
#mbcontrol -t bluebox
mbcontrol -t blondie

echo
echo "Window options tester"
echo "====================="
echo
echo "Press <enter> to start a test. Press <enter> to quit a test."
echo "In Matchbox, use Alt-p to get back to terminal (to press <enter>)"
echo "while the test is running."
echo
echo "on other window managers you might use e.g. <TAB> to change"
echo "the focus back to this terminal."
echo

count=0

echo; echo "$count. 4 queued message windows from two clients at alternate sides"; read
./winspew -t "Window",normal -c "Dialog",300x200 -t MSG1,message,90x60+20-20,,10 -t MSG2,message,90x60-20-20,,10 >> $LOG &
TEST1=$!
sleep 1
./winspew -t MSG1,message,300x200+20+20,,10 -t MSG2,message,300x200-20+20,,10 >> $LOG &
TEST2=$!
read; kill $TEST1 $TEST2; wait; count=$((count+1))

echo; echo "$count. Fullscreen window"; read
./winspew -t "Window",normal,,fullscreen >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with dialog"; read
./winspew -t "Window",normal,,fullscreen -c "Dialog",320x200 >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with modal dialog"; read
./winspew -t "Window",normal,,fullscreen -c "Dialog",320x200,modal >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with no-title dialog"; read
./winspew -t "Window",normal,,fullscreen -c "Dialog",300x200,no_title >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window"; read
./winspew -t "Window",normal >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with several dialogs"; read
./winspew -t "Window",normal -c "Dialog",320x220 -c "Dialog",400x300 -c "Dialog",300x200 >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with dialog with help/accept buttons"; read
./winspew -t "Window",normal -c "Dialog",320x200,accept_button:help_button >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with several modal dialogs"; read
./winspew -t "Window",normal -c "Dialog",320x220,modal -c "Dialog",400x300,modal -c "Dialog",300x200,modal >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with no-title dialog"; read
./winspew -t "Window",normal -c "Dialog",300x200,no_title >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with no-decor dialog"; read
./winspew -t "Window",normal -c "Dialog",300x200,no_decor >> $LOG &
TEST=$!; read; kill $TEST; wait; count=$((count+1))

echo
echo "$count tests done!"
echo
echo "Winspew test program outputs were logged into file '$LOG'."
