/*
 * Filter for displaying only twin primes.
 *
 * Copyright (C) 2004 George Gesslein II.
 *
 * Usage: matho-primes | matho-twin
 *
 * Changes:
 *
 * 11/22/05 - converted everything to long doubles.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#if	UNIX
#include <libgen.h>
#endif
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <math.h>

#define	true	1
#define	false	0

void	usage(void);
int	get_long_double_int(char *cp, long double *dp);

char	*prog_name = "matho-twin";

int
main(int argc, char *argv[])
{
	long double	d1, d2;
	char		buf[100];

#if	UNIX
        prog_name = strdup(basename(argv[0]));
#endif
	if (isatty(0) || argc > 1) {
		usage();
	}
	d1 = -3.0;
	for (;;) {
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
		if (!get_long_double_int(buf, &d2)) {
			fprintf(stderr, "%s: Error in input number.\n", prog_name);
			exit(1);
		}
		if (fabsl(d1 - d2) == 2.0) {
			printf("%.0Lf %.0Lf\n", d1, d2);
		}
		d1 = d2;
	}
	exit(0);
}

int
get_long_double_int(char *cp, long double *dp)
{
	if (sscanf(cp, "%Lf", dp) != 1) {
		return false;
	}
	if (*dp < 0.0 || fmodl(*dp, 1.0L) != 0.0) {
		return false;
	}
	return true;
}

void
usage()
{
	fprintf(stderr, "Usage: matho-primes | %s\n\n", prog_name);
	fprintf(stderr, "Filter for displaying only twin primes (primes that differ by 2).\n");
	exit(1);
}
