(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicLibrary.ml 8535 2008-05-14 15:36:26Z sacerdot $ *)

exception ObjectNotFound of string Lazy.t

let cache = NUri.UriHash.create 313;;

let get_obj u =
  try NUri.UriHash.find cache u
  with Not_found ->
    (* in the final implementation should get it from disk *)
    let ouri = NCic2OCic.ouri_of_nuri u in
    let o,_ = CicEnvironment.get_obj CicUniv.oblivion_ugraph ouri in
    let l = OCic2NCic.convert_obj ouri o in
    List.iter (fun (u,_,_,_,_ as o) -> 
(*       prerr_endline ("+"^NUri.string_of_uri u);  *)
      NUri.UriHash.add cache u o) l;
    HExtlib.list_last l
;;
