(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicUnification.mli 9356 2008-12-15 19:16:46Z ricciott $ *)

exception UnificationFailure of string Lazy.t;;
exception Uncertain of string Lazy.t;;
exception AssertFailure of string Lazy.t;;

val unify :
  NCicUnifHint.db ->
  NCic.metasenv -> NCic.substitution -> NCic.context -> 
  NCic.term -> NCic.term ->
   NCic.metasenv * NCic.substitution

(* 
exception UnificationFailure of string Lazy.t;;
exception Uncertain of string Lazy.t;;
exception AssertFailure of string Lazy.t;;

(* fo_unif metasenv context t1 t2                *)
(* unifies [t1] and [t2] in a context [context]. *)
(* Only the metavariables declared in [metasenv] *)
(* can be used in [t1] and [t2].                 *)
(* The returned substitution can be directly     *)
(* withouth first unwinding it.                  *)
val fo_unif :
  Cic.metasenv -> Cic.context -> 
    Cic.term -> Cic.term -> CicUniv.universe_graph -> 
      Cic.substitution * Cic.metasenv * CicUniv.universe_graph

(* fo_unif_subst metasenv subst context t1 t2    *)
(* unifies [t1] and [t2] in a context [context]  *)
(* and with [subst] as the current substitution  *)
(* (i.e. unifies ([subst] [t1]) and              *)
(* ([subst] [t2]) in a context                   *)
(* ([subst] [context]) using the metasenv        *)
(* ([subst] [metasenv])                          *)
(* Only the metavariables declared in [metasenv] *)
(* can be used in [t1] and [t2].                 *)
(* [subst] and the substitution returned are not *)
(* unwinded.                                     *)
(*CSC: fare un tipo unione Unwinded o ToUnwind e fare gestire la
 cosa all'apply_subst!!!*)
val fo_unif_subst :
  Cic.substitution -> Cic.context -> Cic.metasenv -> 
    Cic.term -> Cic.term -> CicUniv.universe_graph ->
      Cic.substitution * Cic.metasenv * CicUniv.universe_graph

      *)
