import numpy as np
import matplotlib.pyplot as plt
import matplotlib.patches as patches
x, y = np.random.rand(2, 200)

fig, ax = plt.subplots()
circ = patches.Circle( (0.5, 0.5), 0.25, alpha=0.8, fc='yellow')
ax.add_patch(circ)


ax.plot(x, y, alpha=0.2)
line, = ax.plot(x, y, alpha=1.0, clip_path=circ)

class EventHandler:
   def __init__(self):
       fig.canvas.mpl_connect('button_press_event', self.onpress)
       fig.canvas.mpl_connect('button_release_event', self.onrelease)
       fig.canvas.mpl_connect('motion_notify_event', self.onmove)
       self.x0, self.y0 = circ.center
       self.pressevent = None

   def onpress(self, event):
      if event.inaxes!=ax:
         return

      if not circ.contains(event)[0]:
         return

      self.pressevent = event

   def onrelease(self, event):
      self.pressevent = None
      self.x0, self.y0 = circ.center

   def onmove(self, event):
      if self.pressevent is None or event.inaxes!=self.pressevent.inaxes:
         return

      dx = event.xdata - self.pressevent.xdata
      dy = event.ydata - self.pressevent.ydata
      circ.center = self.x0 + dx, self.y0 + dy
      line.set_clip_path(circ)
      fig.canvas.draw()

handler = EventHandler()
plt.show()
