/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.PrintStream;

public class ABAPStreamDescriptor {
    protected ABAPStreamTranslator translator;
    protected StructuredBytes descriptor;
    protected StructuredMem descriptorMark;
    protected int rowSize;

    public ABAPStreamDescriptor(ABAPStreamTranslator aBAPStreamTranslator) {
        this.translator = aBAPStreamTranslator;
        this.descriptor = new StructuredBytes(aBAPStreamTranslator.physicalLength - 1);
        this.descriptorMark = null;
        this.rowSize = 0;
    }

    public void clearColumns() {
        this.descriptor.putInt2(0, 10);
        this.descriptor.putInt2(0, 8);
    }

    public void addColumn(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.descriptor.getInt2(10);
        if (this.descriptor.size() < 20 + (n7 + 1) * 8) {
            this.expandDescriptor(20 + (n7 + 1) * 8);
        }
        this.descriptor.putInt2(n7 + 1, 10);
        this.rowSize = this.descriptor.getInt2(8);
        this.rowSize = Math.max(this.rowSize, n3 + n6);
        this.descriptor.putInt2(this.rowSize, 8);
        this.descriptor.putInt1(n, 20 + 8 * n7 + 0);
        this.descriptor.putInt1(n2, 20 + 8 * n7 + 1);
        this.descriptor.putInt2(n4, 20 + 8 * n7 + 2);
        this.descriptor.putInt2(n3, 20 + 8 * n7 + 4);
        this.descriptor.putInt2(n6, 20 + 8 * n7 + 6);
    }

    private void expandDescriptor(int n) {
        byte[] byArray = this.descriptor.bytes();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.descriptor = new StructuredBytes(byArray2);
    }

    public void updateIndex(int n) {
        this.descriptorMark.putInt4(n, 16);
    }

    public void putDescriptor(StructuredMem structuredMem, int n) {
        structuredMem.putInt1(0, n - 1);
        structuredMem.putBytes(this.descriptor.bytes(), n);
        this.descriptorMark = structuredMem.getPointer(n);
    }

    public void traceOn(PrintStream printStream) {
        printStream.println("DESCRIPTOR");
        printStream.println("  ROW SIZE       : " + this.descriptor.getInt2(8));
        int n = this.descriptor.getInt2(10);
        printStream.println("  COLUMN COUNT   : " + n);
        printStream.println("  ROW COUNT      : " + this.descriptor.getInt4(12));
        printStream.println("  TAB ID         : " + this.descriptor.getInt4(16));
        for (int i = 0; i < n; ++i) {
            byte by = this.descriptor.getInt1(i * 8 + 20 + 0);
            byte by2 = this.descriptor.getInt1(i * 8 + 20 + 1);
            int n2 = this.descriptor.getInt2(i * 8 + 20 + 4);
            int n3 = this.descriptor.getInt2(i * 8 + 20 + 2);
            int n4 = this.descriptor.getInt2(i * 8 + 20 + 6);
            printStream.println("    COLDESC[" + (i + 1) + "]");
            printStream.println("      INOUT   : " + ABAPStreamDescriptor.inout(by));
            printStream.println("      TYPE    : " + ABAPStreamDescriptor.type(by2) + " (" + by2 + ")");
            printStream.println("      LENGTH  : " + n2);
            printStream.println("      PREC    : " + n3);
            printStream.println("      OFFSET  : " + n4);
        }
    }

    private static String type(int n) {
        switch (n) {
            case 0: {
                return "BOOL";
            }
            case 14: {
                return "CHAR";
            }
            case 10: {
                return "DOUBLE";
            }
            case 9: {
                return "FLOAT";
            }
            case 1: {
                return "INT1";
            }
            case 3: {
                return "INT2";
            }
            case 5: {
                return "INT4";
            }
            case 7: {
                return "INT8";
            }
            case 17: {
                return "WYDE";
            }
        }
        return "Unknown type (" + n + ")";
    }

    private static String inout(int n) {
        switch (n) {
            case 0: {
                return "IN";
            }
            case 1: {
                return "OUT";
            }
            case 2: {
                return "IN/OUT";
            }
        }
        return "???";
    }
}

