/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import java.sql.SQLException;

public abstract class GarbageCan {
    protected int canTresholdC = 20;
    protected boolean objPending = false;
    protected boolean currentEmptyRun = false;
    protected boolean currentEmptyRun2 = false;

    public GarbageCan() {
        this(20);
    }

    public GarbageCan(int n) {
        this.canTresholdC = n;
    }

    public boolean isPending() {
        this.objPending = this.getGarbageSize() >= this.canTresholdC;
        return this.objPending;
    }

    public final void forceGarbageCollection() {
        this.objPending = true;
    }

    public final void emptyCan(ConnectionSapDB connectionSapDB) {
        if (this.currentEmptyRun) {
            return;
        }
        this.currentEmptyRun = true;
        this.objPending = false;
        while (this.getGarbageSize() > 0) {
            try {
                RequestPacket requestPacket = connectionSapDB.getRequestPacket();
                requestPacket.initializePacket((short)Short.MAX_VALUE);
                this.emptyCan(requestPacket);
                connectionSapDB.execute(requestPacket, this, 3);
            }
            catch (SQLException sQLException) {}
        }
        this.currentEmptyRun = false;
    }

    public abstract void emptyCan();

    public abstract void throwIntoGarbageCan(Object var1);

    protected abstract int getGarbageSize();

    public abstract boolean emptyCan(RequestPacket var1);

    public abstract boolean packetAction(RequestPacket var1, Object var2);
}

