/*!
  @file           FBM_SequentialRandomDataDevice.hpp
  @author         TorstenS
  @author         AlexanderK
  @ingroup        FBM

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#ifndef FBM_SEQUENTIALDATAVOLUME_H
#define FBM_SEQUENTIALDATAVOLUME_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "FreeBlockManagement/FBM_IDataVolume.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!
  @class          FBM_SequentialDataVolume
  @brief          representation of one data volume
 */
class FBM_SequentialDataVolume : public FBM_IDataVolume
{
private:
    const SAPDB_Int4           m_NumBlocks;
    const RTE_VolumeAccessMode m_VolMode;
    SAPDB_Int4                 m_LastUsedBlock;
    SAPDB_Int4                 m_FirstFreeBlock;
    SAPDB_Int4                 m_NumBlocksUsed;
    SAPDB_Bool                 m_DeviceIsInCompressingMode;

public:
    
    FBM_SequentialDataVolume (SAPDBMem_IRawAllocator &Allocator,
                              SAPDB_Int4 VolumeSize,
                              RTE_VolumeAccessMode VolMode)
        :
        FBM_IDataVolume(),
        m_NumBlocks                        (VolumeSize),
        m_VolMode                          (VolMode),
        m_NumBlocksUsed                    (FBM_UNDEFINED),
        m_LastUsedBlock                    (FBM_UNDEFINED),
        m_FirstFreeBlock                   (FBM_UNDEFINED),
        m_DeviceIsInCompressingMode        (false) 
    {}

    void InitVolume ();
    
    FBM_BlockState GetBlockState(SAPDB_Int4 BlockNo) const;

    void SetBlockStateToFree (SAPDB_Int4 BlockNo);
    
    void SetBlockStateToOccupied (SAPDB_Int4 BlockNo);
    
    SAPDB_Int4 GetNumBlocksUsed() const;

    SAPDB_Int4 GetNumBlocksFree() const;

    RTE_VolumeAccessMode VolMode() const;

    SAPDB_Int4 GetMultFreeBlocks (
        const SAPDB_Int4  NumBlocksWanted,
        SAPDB_Int4       &NumBlocksSupplied);

    SAPDB_Int4 GetFreeBlock ();

    void Verify ();
    
    void GetDeviceStatistics (SAPDB_Int4 &NumBlocks,
        SAPDB_Int4 &NumBlocksFree,
        SAPDB_Int4 &NumBlockFreeAfterSVP) const;

    /*--------------------------------------------------------------------------
    function:     Dump()
    description:  insert all state information of a data devspace into the 
                  kernel dump file
    arguments:    dump [in/out] kernel dump file
                  devNo [in] logical identifier for a data devspace
    return value: none
    --------------------------------------------------------------------------*/

    void Dump( 
        Kernel_Dump      &dump,
        const SAPDB_Int4 devNo) const;
};

#endif //FBM_SEQUENTIALDATAVOLUME_H
