/*!
  @file           IFRConversion_BooleanConverter.cpp
  @author         D039759
  @ingroup        IFR_DataConv
  @brief          
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end






\endif
*/
#include "SAPDB/Interfaces/Runtime/IFR_Common.h"
#include "SAPDB/Interfaces/Runtime/Conversion/IFRConversion_BooleanConverter.h"

#include <stdlib.h>
#include <errno.h>
#include <ctype.h>

#define DBUG_CLINK_METHOD_ENTER(x,y) DBUG_CONTEXT_METHOD_ENTER(x, y, &clink)

//----------------------------------------------------------------------
IFRConversion_BooleanConverter::IFRConversion_BooleanConverter(IFR_ShortInfo& shortinfo,
                                                               SAPDBMem_IRawAllocator& allocator)
:IFRConversion_Converter(shortinfo, allocator)
{}

//----------------------------------------------------------------------
IFRConversion_BooleanConverter::~IFRConversion_BooleanConverter()
{
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_Int1&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_UInt1&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}


//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_Int2&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}


//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_UInt2&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_Int4&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_UInt4&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_Int8&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               IFR_UInt8&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               double&           data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data != 0.0) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& datapart,
                                               float&              data,
                                               IFR_Length*           lengthindicator,
                                               IFR_ConnectionItem &clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateInput);
    char putdata[2];
    putdata[0]=0;
    if(data != 0.0) {
        putdata[1]=1;
    } else {
        putdata[1]=0;
    }
    datapart.addData(putdata, m_shortinfo.bufpos, m_shortinfo.iolength);
    DBUG_RETURN(IFR_OK);
}


//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_Int1&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_Int2&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_Int4&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_Int8&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}


//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_UInt1&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_UInt2&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_UInt4&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                IFR_UInt8&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1;
    } else {
        data=0;
    }
    DBUG_RETURN(IFR_OK);
}


//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                double&             data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1.0;
    } else {
        data=0.0;
    }
    DBUG_RETURN(IFR_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& datapart,
                                                float&           data,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem & clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_BooleanConverter, translateOutput);
    if(((unsigned char *)datapart.getParameterData(m_shortinfo.bufpos))[0]) {
        data=1.0f;
    } else {
        data=0.0f;
    }
    DBUG_RETURN(IFR_OK);
}

#if IFR_NEED_VIRTUAL_DELEGATION

#define TRANSLATE_METHOD_IMPL(xxtype)                                                               \
IFR_Retcode                                                                                         \
IFRConversion_BooleanConverter::translateInput(IFRPacket_DataPart& part,                            \
                                            xxtype& data,                                           \
                                            IFR_Length* lengthindicator,                            \
                                            IFR_ConnectionItem& clink)                              \
{                                                                                                   \
    return IFRConversion_Converter::translateInput(part, data, lengthindicator, clink);             \
}                                                                                                   \
IFR_Retcode                                                                                         \
IFRConversion_BooleanConverter::translateOutput(IFRPacket_DataPart& part,                           \
                                            xxtype& data,                                           \
                                            IFR_Length* lengthindicator,                            \
                                            IFR_ConnectionItem& clink)                              \
{                                                                                                   \
    return IFRConversion_Converter::translateOutput(part, data, lengthindicator, clink);            \
}

TRANSLATE_METHOD_IMPL(SQL_TIME_STRUCT)
TRANSLATE_METHOD_IMPL(SQL_DATE_STRUCT)
TRANSLATE_METHOD_IMPL(SQL_TIMESTAMP_STRUCT)
TRANSLATE_METHOD_IMPL(SQL_NUMERIC_STRUCT)
TRANSLATE_METHOD_IMPL(GUID)

#endif
