/*!
  @file           IFRPacket_PartEnum.cpp
  @author         ThomasS
  @ingroup        IFR_Packet
  @brief          Implements class for part enumeration.
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end






\endif
*/
#include "SAPDB/Interfaces/Runtime/IFR_Common.h"
#include "SAPDB/Interfaces/Runtime/Packet/IFRPacket_PartEnum.h"

#define DBUG_NULL_METHOD_ENTER(x,y) DBUG_CONTEXT_METHOD_ENTER(x, y, (IFR_TraceStream *)0)

IFRPacket_PartEnum::IFRPacket_PartEnum (IFRPacket_ReplySegment *reply)
  : m_ReplySegment (reply)
{
  short nrOfParts;
  tsp1_segment_header *hdr = reply->GetRawHeader ();

  memcpy (&nrOfParts, (char *) hdr + 8, sizeof (short));
  this->m_PartsLeft = nrOfParts;
  this->m_Part =  m_ReplySegment->getFirstPart ();
}

bool IFRPacket_PartEnum::hasMoreElements ()
{
  DBUG_NULL_METHOD_ENTER(IFRPacket_PartEnum, hasMoreElements);
  DBUG_RETURN(this->m_PartsLeft > 0);
}

IFRPacket_Part IFRPacket_PartEnum::nextElement ()
{
  --this->m_PartsLeft;
  m_Part =  m_ReplySegment->getNextPart ();
  return m_Part;
}

IFRPacket_Part IFRPacket_PartEnum::getPart ()
{
  return m_Part;
}

IFRPacket_PartKind::PartKind IFRPacket_PartEnum::partKind ()
{
  return (IFRPacket_PartKind::PartKind)m_ReplySegment->partKind ();
}

int IFRPacket_PartEnum::pos ()
{
  return 0;
}
