/*!
  @file           IFRPacket_PartEnum.h
  @author         ThomasS
  @ingroup        IFR_Packet
  @brief          Implements class for part enumeration.
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end






\endif
*/
#ifndef IFRPACKET_PARTENUM_H
#define IFRPACKET_PARTENUM_H
#include "SAPDB/Interfaces/Runtime/Packet/IFRPacket_ReplySegment.h"
#include "SAPDB/Interfaces/Runtime/Packet/IFRPacket_Part.h"

class IFRPacket_PartEnum {
public:
  
  IFRPacket_PartEnum (IFRPacket_ReplySegment *reply);

  bool hasMoreElements ();

  IFRPacket_Part nextElement ();

  IFRPacket_Part getPart ();

  IFRPacket_PartKind::PartKind partKind ();

  int pos ();
  
private:
  int m_PartsLeft;
  IFRPacket_ReplySegment *m_ReplySegment;
  IFRPacket_Part m_Part;
};
#endif //IFRPACKET_PARTENUM_H
