/*!
  @file           SQLDBC_ClientTrace.cpp
  @author         D039759
  @ingroup        SQLDBC
  @brief          Additional trace functionality only of use with Client Runtime.
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#include "Interfaces/SQLDBC/SQLDBC_IRuntime.h"
#include "Interfaces/SQLDBC/SQLDBC_ClientTrace.h"

// 'this' must occur in tracestream initializer, even if it's dangerous.
#ifdef WIN32
#pragma warning( disable : 4355)
#endif

//----------------------------------------------------------------------
SQLDBC_ClientTrace::SQLDBC_ClientTrace(SQLDBC_IRuntime* runtime)
:m_clientruntime((SQLDBC_ClientRuntime *)runtime),
 m_tracestream(this)
{
    const char *runtime_id = runtime->getIdentifier();
    if(strlen(runtime_id) < 20 || memcmp(runtime_id, "SQLDBC_ClientRuntime", 20)) {
        sqlabort();
    }
}

#ifdef WIN32
#pragma warning( default : 4355)
#endif

//----------------------------------------------------------------------
SQLDBC_ClientTrace::~SQLDBC_ClientTrace()
{}

//----------------------------------------------------------------------
void
SQLDBC_ClientTrace::write(const char *data, IFR_Int4 length)
{
    m_clientruntime->write(data, length);
}

//----------------------------------------------------------------------
void
SQLDBC_ClientTrace::writeln(const char *data, IFR_Int4 length)
{
    m_clientruntime->writeln(data, length);
}

//----------------------------------------------------------------------
SQLDBC_IRuntime::TaskTraceContext *
SQLDBC_ClientTrace::traceflags()
{
    return m_clientruntime->getTaskTraceContext();
}

//----------------------------------------------------------------------
SAPDBMem_IRawAllocator&
SQLDBC_ClientTrace::getAllocator()
{
    return m_clientruntime->getGlobalAllocator();
}

//----------------------------------------------------------------------
void
SQLDBC_ClientTrace::addTraceFlags(unsigned int flags)
{
    m_clientruntime->addTraceFlags(flags);
}

//----------------------------------------------------------------------
void
SQLDBC_ClientTrace::removeTraceFlags(unsigned int flags)
{
    m_clientruntime->removeTraceFlags(flags);
}
