#ifndef JOIN_ACCESSDESC_HPP
#define JOIN_ACCESSDESC_HPP
/*!
 * @file
 * @brief encapsulate type tgg00_MessBlock
 *
 * Join_AccessDesc describes access to base table. tgg00_MessBlock contains
 * which columns should delivered, which access mehod (key/index) is used etc.
 * 
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_AccessOperator.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "Join/Join_Types.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "vak001.h"
#include "ggg00.h"
#include "ggg07.h"
#include "hak70.h"

//! encapsulation for tgg00_MessBlock
class Join_AccessDesc 
{
public:
    //! @name constructor / destructor
    //@{
    //! constructor
    Join_AccessDesc(tak_all_command_glob& acv);

    //! destructor
    ~Join_AccessDesc();
    //@}
    
    //! @name properties 
    //@{
    //! is index access to base table?
    SAPDB_Bool IsIndexAccess() const
    { return ( a70glob_inv_strats.includes( m_strategy->str_strategy ) ||
                 a70glob_join_inv_strats.includes( m_strategy->str_strategy )); }
    
    //! could we fetch results or we have to build result file
    SAPDB_Bool IsFetchAccess() const
    { return a70glob_fetch_strats.includes( m_strategy->str_strategy ) || strat_viewkey == m_strategy->str_strategy ; }
    
    //! is there a join access method to base table (special strategy names)
    SAPDB_Bool IsJoinAccess() const
    { return a70glob_join_strats.includes( m_strategy->str_strategy ); }
    
    //! is there a join access method via index to base table
    SAPDB_Bool IsJoinInvAccess() const
    { return a70glob_join_inv_strats.includes( m_strategy->str_strategy ); }
    
    //! return file IDs of base table und used index
    tgg00_TwoFileIds& FileIDs() { return m_fileids; }
    
    //! return encapsulated message block
    tgg00_MessBlock& MBlock() { return m_mblock; }
    
    //! return SQL mode
    tsp00_SqlMode_Enum SQLMode() const { return m_mblock.mb_qual()->msqlmode(); }

    //! return whole strategy information
    const tgg07_StrategyInfo* Strategy() const { return m_strategy; }

    //! get record length of selected records
    SAPDB_UInt2 GetRecordLength() const { return m_strategy->str_rec_len; }
    
    //! get key length of selected records
    SAPDB_UInt2 GetKeyLength() const { return m_strategy->str_key_len; }

    //! comprise base table several files?
    SAPDB_Bool IsVirtualFile() const 
    { 
        return m_strategy->str_all_files && 
            ( ttfnRecursive_egg00 == m_fileids.file_id.fileTfnTemp_gg00() ) &&
            ( *(SAPDB_Int2*)&m_fileids.file_id.fileLevel_gg00() > 1 ); 
    }

    //! Returns true if hash join should be used.
    SAPDB_Bool UseHashJoin() const;

    //! Returns true if parallel index access should be used.
    SAPDB_Bool UseParallelIndexAccess() const;

    //! get start/stop keys corresponding to given access strategy
    tgg00_BasisError CreateKeys(
            Join_TwoKeys& startkey,
            Join_TwoKeys& stopkey );
    //@}

    //! @name manipulation
    //@{
    //! if base table comprises several files switch to next file
    void SetNextFileID() 
    { 
        *(SAPDB_Int2*)&m_fileids.file_id.fileLevel_gg00() -= 1; 
        m_fileids.file_id.fileRoot_gg00() = NIL_PAGE_NO_GG00;
    }

    //! if base table comprises several files switch to first file
    void ResetFileID() 
    {
        m_fileids.file_id = m_mblock.mb_qual()->mtree();
        m_fileids.file_id.fileLeafNodes_gg00() = cgg_nil_leafnodes;
    }
    //@}
    
private:
    // member methods
    tgg00_BasisError init_mblock();

    SAPDB_UInt2 strategy_len() const
    { return (*m_mblock.mb_st())[m_mblock.mb_qual()->mstrat_pos()-1].elen_var(); }
    
    SAPDB_UInt2 strategy_pos() const
    { return (*m_mblock.mb_st())[m_mblock.mb_qual()->mstrat_pos()-1].epos(); }
    
    SAPDBMem_IRawAllocator& get_alloc() const { 
            return *(REINTERPRET_CAST( SAPDBMem_IRawAllocator*,  
                        m_acv.a_transinf.tri_trans.trAllocator_gg00) ); }

    // member variables
    tak_all_command_glob&   m_acv;
    tgg00_MessBlock         m_mblock;
    tgg07_StrategyInfo*     m_strategy;
    tgg00_TwoFileIds        m_fileids;
};

/*************************************************************************/

inline SAPDB_Bool Join_AccessDesc::UseHashJoin() const
{
    return m_strategy->str_access_mod.includes(strmod_hash);
}

/*************************************************************************/

inline SAPDB_Bool Join_AccessDesc::UseParallelIndexAccess() const
{
    return m_strategy->str_access_mod.includes(strmod_parallel);
}

#endif
