#ifndef JOIN_INDEXACCESSOPERATOR_HPP
#define JOIN_INDEXACCESSOPERATOR_HPP
/*!
 * @file  Join_IndexAccessOperator.hpp
 * @brief realize one table access operator by means of Join_AccessDesc
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_AccessDesc.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "Join/Join_Types.hpp"
#include "SAPDB/Join/Join_AccessOperator.hpp"
#include "SAPDB/SAPDBCommon/SAPDB_Types.hpp"
#include "vak001.h"
#include "ggg00.h"

class Join_InvSelectIterator; //<! forward declaration

//! operator for base table access via key or index
class Join_IndexAccessOperator : public Join_AccessOperator {
public:
    enum AccessKind {
        ParallelAccess,
        SerialAccess
    };

    //! @name constructor / destructor
    //@{
    //! constructor
    Join_IndexAccessOperator(
        tak_all_command_glob& acv,
        const AccessKind      accessKind    = SerialAccess,
        SAPDB_Byte*           bufferPtr     = 0,
        const SAPDB_UInt4&    buffersize    = BUF8K_MXSP00);

    //! destructor
    virtual ~Join_IndexAccessOperator();
    //@}

    //! open operator with keys given by strategy information
    virtual void Open();

    //! open stream operator and limit stream with start/stop key
    virtual void Open(
        const Join_TwoKeys& startkeys,
        const Join_TwoKeys& stopkeys );

    //! close operator
    virtual void Close();
    //@}

protected:

    // member methods
    virtual tgg00_BasisError init();
    virtual void SelectRecords();

    // member variables
    Join_InvSelectIterator* m_pInvIterator;
};

#endif
