/*!
 * @brief types used by Join component
 *
 * @author ThomasA
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/


#ifndef JOIN_TYPES_HPP
#define JOIN_TYPES_HPP

#include "ggg00.h"
#include "SAPDB/SAPDBCommon/SAPDB_RangeCode.hpp"

/*!
   @brief defines two key (base table key and inv key).  
 */
class Join_TwoKeys : public tgg00_TwoKeys
{
public :
    /*!
       @brief default constructor, initializes both key with length 0
     */
    Join_TwoKeys()
    {
        reckey.len()  = 0;
        listkey.len() = 0;
    }
    /*!
       @brief copy constructor
     */
    Join_TwoKeys(const Join_TwoKeys& source)
    {
        *this = source;
    }
    /*!
       @brief assignment operator, checks for admissable key length
     */
    inline void operator=(const Join_TwoKeys& source)
    {
        this->reckey.len() = source.reckey.len();
        if ((source.reckey.len() < -1) || (source.reckey.len() > (int) sizeof(this->reckey.k())))
        {
            tgg00_BasisError e = e_ok;
            // SAPDB_RangeMove will notice the error and will write a trace into knldiag
            SAPDB_RangeMove (__FILE__, 1, sizeof(source.reckey.k()), sizeof(this->reckey.k()), 
                &source.reckey.k(), 1, &this->reckey.k(), 1, source.reckey.len(), e);
            this->reckey.len()  = -1; 
            this->listkey.len() = -1;
            return;
        }
        if (source.reckey.len() > 0)  
        {
            memcpy (&this->reckey.k(), &source.reckey.k(), source.reckey.len()); 
        }
        this->listkey.len() = source.listkey.len();
        if ((source.listkey.len() < -1) || (source.listkey.len() > (int) sizeof(this->listkey.k())))
        {
            tgg00_BasisError e = e_ok;
            // SAPDB_RangeMove will notice the error and will write a trace into knldiag
            SAPDB_RangeMove (__FILE__, 2, sizeof(source.listkey.k()), sizeof(this->listkey.k()), 
                &source.listkey.k(), 1, &this->listkey.k(), 1, source.listkey.len(), e);
            this->listkey.len() = -1;
            return;
        }
        if (source.listkey.len() > 0) 
        {
            memcpy (&this->listkey.k(), &source.listkey.k(), source.listkey.len()); 
        }
    }
};

#endif
