#ifndef __OMS_FREELISTHEADER_HPP
#define __OMS_FREELISTHEADER_HPP

#include "Oms/OMS_FreeListHeaderDef.hpp"
#include "Oms/OMS_ContextDef.hpp"

inline OMS_FreeListHeader::OMS_FreeListHeader(size_t sz) : next(NULL), size(sz), free(NULL) 
{
}

/*----------------------------------------------------------------------*/

inline void* OMS_FreeListHeader::operator new(size_t sz, OMS_Context* context) 
{
  return context->allocate(sz);
}

/*----------------------------------------------------------------------*/

#if defined(OMS_PLACEMENT_DELETE)
inline void OMS_FreeListHeader::operator delete (void* p, OMS_Context* context) 
{
  context->deallocate(p);
}
#endif

/*----------------------------------------------------------------------*/

inline void OMS_FreeListHeader::DeleteSelf (OMS_Context* context) 
{
  context->deallocate(this);
}

#endif // __OMS_FREELISTHEADER_HPP
