#ifndef __OMS_GUID_HPP
#define __OMS_GUID_HPP

/* define, if we implement integer GUIDs */
#ifndef LIVECACHE_LONGGUIDS
#define	LIVECACHE_INTGUIDS
#endif

#ifdef	LIVECACHE_INTGUIDS

typedef int			ClassID;
#define	ClassIDPtr	ClassID
#define	ClassIDRef	ClassID
#define	GUID_TEMP(lguid, guid)					\
  GUID lguid;									\
  if (guid == OMS_VAR_OBJ_GUID) {			\
  memcpy(&lguid, &OMS_VAR_OBJ_GUID_DEF,	\
  sizeof(lguid));						\
  } else {									\
  memset(&lguid, 0, sizeof(lguid));		\
  lguid.Data1 = guid;						\
  }

#define GUID_MASK_ARRAY ((1<<21) - 1)

#define omsMakeArrayGuid(guid, array) guid = (guid & GUID_MASK_ARRAY) | \
  (((array + 7) >> 3) << 21)
#define omsMaskGuid(guid) ((guid) & GUID_MASK_ARRAY)
#define omsIsCompatibleGuid(guid1, guid2) ((((guid1) ^ (guid2)) & GUID_MASK_ARRAY) == 0)

#else   // LIVECACHE_INTGUIDS

#define ClassID		GUID
#define	ClassIDPtr	GUID*
#define	ClassIDRef	GUID&
#define	GUID_TEMP(lguid, guid)	const GUID &lguid = guid

#define omsIsCompatibleGuid(guid1, guid2) ((guid1) == (guid2))
#define omsMakeArrayGuid(guid, array)
#define omsMaskGuid(guid) (guid)

#endif  // !LIVECACHE_INTGUIDS

#endif  // __OMS_GUID_HPP