#include "Oms/OMS_Malloc.hpp"
#include "Oms/OMS_Globals.hpp"

/*----------------------------------------------------------------------*/

void* omsMalloc(size_t size) 
{
  return OMS_Globals::KernelInterfaceInstance->Allocate(size);
}

/*----------------------------------------------------------------------*/

void* omsMallocArray(size_t size) 
{
  return OMS_Globals::KernelInterfaceInstance->AllocateArray(size);
}

/*----------------------------------------------------------------------*/

void omsFree(void* p) 
{
  OMS_Globals::KernelInterfaceInstance->Deallocate(p);
}

/*----------------------------------------------------------------------*/

void omsFreeArray(void* p) 
{
  OMS_Globals::KernelInterfaceInstance->DeallocateArray(p);
}

