#ifndef __OMS_TIMESTAMP_HPP
#define __OMS_TIMESTAMP_HPP

#include "Oms/OMS_DateTime.hpp"
#include "livecachetypes.h" // nocheck

class AFX_EXT_CLASS OmsTimeStamp
{
public:
  OmsTimeStamp(const OmsTypeABAPTimeStamp& timeStamp);

  typedef struct _TimeStamp
  {
    unsigned char nYear1   : 4;
    unsigned char nPad     : 4;

    unsigned char nYear3   : 4;
    unsigned char nYear2   : 4;

    unsigned char nMonth1  : 4;
    unsigned char nYear4   : 4;

    unsigned char nDay1    : 4;
    unsigned char nMonth2  : 4;

    unsigned char nHour1   : 4;
    unsigned char nDay2    : 4;

    unsigned char nMinute1 : 4;
    unsigned char nHour2   : 4;

    unsigned char nSecond1 : 4;
    unsigned char nMinute2 : 4;

    unsigned char nSign    : 4;
    unsigned char nSecond2 : 4;
  } TimeStamp;

  // Auslesen der Daten:
  const OmsTypeABAPTimeStamp& omsGetTimeStamp() const;
  OmsTypeUInt4 omsSecsSince01011970() { return m_DateTime.getDTValue(); }  
protected:
  // Konvertierung der Daten:
  void ToTimeStamp();
  void ToDateTime();

  // Schnelle Multiplikations- und Divisionsfunktionen
  inline int mult10(int n)
  {
    return (n << 3) + (n << 1);
  }

  inline int mult100(int n)
  {
    return (n << 6) + (n << 5) + (n << 2);
  }

  inline int mult1000(int n)
  {
    register int a;
    a = mult100(n);
    return mult10(a);
  }

  inline void div10(int n, int& n10, int& n1)
  {
    n1  = n;
    n10 = 0;

    while (n1 >= 10)
    {
      n1 -= 10;
      n10++;
    }
  }

  inline void div1000(int n, int& n1000, int& n100, int& n10, int& n1)
  {
    n100  = n;
    n1000 = 0;

    while (n100 >= 1000)
    {
      n100 -= 1000;
      n1000++;
    }

    n10  = n100;
    n100 = 0;

    while (n10 >= 100)
    {
      n10 -= 100;
      n100++;
    }

    n1  = n10;
    n10 = 0;

    while (n1 >= 10)
    {
      n1 -= 10;
      n10++;
    }
  }
protected:
  OMS_DateTime m_DateTime;
  union {
    TimeStamp            m_TimeStamp;
    OmsTypeABAPTimeStamp m_ABAPTimeStamp;
  };
};

#endif // __OMS_TIMESTAMP_HPP
