/*!**************************************************************************

  module      : RTEMem_AllocatorInfoReader.hpp

  -------------------------------------------------------------------------

  responsible : UlrichJ

  special area: RTE Memory Allocator Statistics Info Reader
  description : This is a Reader class for sequential reading of the
                memory allocator information.
                For more information about how to use this reader
                class, please take a look at: 
                SystemViews\SysView_MemoryAllocatorStatistics.cpp -> Execute()

  last changed: 2002-08-14
  see also    :

  -------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/


#ifndef RTEMEM_ALLOCATORINFOREADER_HPP
#define RTEMEM_ALLOCATORINFOREADER_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "RunTime/MemoryManagement/RTEMem_AllocatorRegister.hpp"
#include "Container/Container_List.hpp"

 /*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

struct RTEMem_AllocatorInfoItem
{
    SAPDB_Int8      siUsedSize;
    SAPDB_Int8      siMaxUsedSize;
    SAPDB_Int8      siAllocatedSize;
    SAPDB_Int8      siAllocateCount;
    SAPDB_Int8      siDeallocateCount;
    SAPDB_Int8      siFailedAllocateCount;
    SAPDB_Int8      siBaseAllocateCount;
    SAPDB_Int8      siBaseDeallocateCount;
    SAPDB_UTF8      siAllocatorName[40+4];
    SAPDB_UTF8      siBaseAllocatorName[40+4];
};

typedef Container_List<RTEMem_AllocatorInfoItem> RTEMem_AllocatorInfoList;

/*!***************************************************************************

   class: RTESync_SpinlockReader

   description: 

******************************************************************************/

class RTEMem_AllocatorInfoReader
{

public:

    /* -----------------------------------------------------------------------*/
    /*! chapter: Constructors and initialization                              */
    /* -----------------------------------------------------------------------*/

    RTEMem_AllocatorInfoReader (SAPDBMem_IRawAllocator &mAlloc);
    
    ~RTEMem_AllocatorInfoReader (void);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Constructors and initialization                           */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Iteration                                                    */
    /* -----------------------------------------------------------------------*/

    SAPDB_Bool First (void);

    SAPDB_Bool Next (RTEMem_AllocatorInfoItem * &pInfo);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Iteration                                                 */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Data Access                                                  */
    /* -----------------------------------------------------------------------*/


    /* -----------------------------------------------------------------------*/
    /*! endchapter: Data Access                                               */
    /* -----------------------------------------------------------------------*/


private:

    void FreeAll (void);

    SAPDBMem_IRawAllocator              &m_Allocator;
    RTEMem_AllocatorInfoList            *m_List;
    RTEMem_AllocatorInfoList::Iterator  m_Current;
        
};

/*!***************************************************************************

   endclass: RTESync_SpinlockReader

******************************************************************************/

#endif  /* RTEMEM_ALLOCATORINFOREADER_HPP */

