/*!========================================================================
  @file         RTE_SecurityAttributesNT.hpp
  @ingroup      Runtime
  @author       StefanP

  @brief        Security Attributes for NT

  @since        2003-09-15  11:42
  @sa           


  =======================================================================

  \if EMIT_LICENCE
    
    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
  \endif
  ----------------------------------------------------------------------------*/


/* NT only */


#ifndef RTE_SECURITYATTRIBUTESNT_HPP
#define RTE_SECURITYATTRIBUTESNT_HPP

#if defined(_WIN32)

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include    "RunTime/RTE_MessageList.hpp"
#include    "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include    "SAPDBCommon/Tracing/SAPDBTrace_Usage.hpp"



extern SAPDBTrace_Topic Runtime_Trace;


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/
/*
typedef enum { RTESys_UndefinedAccess = 0,
               RTESys_WorldAccess,
               RTESys_LockAccess,
} RTESys_SecurityType;
*/

/*!
  @class          RTE_SecurityAttributes
  @brief    
 */


class RTE_SecurityAttributes
{
public:

  /*!
     @brief    Returns reference to single instance of RTE_SecurityAttributes
     @return         Reference to RTE_SecurityAttributes instance

  */


    static  RTE_SecurityAttributes &   Instance ();

  /*!
     @brief          Destructor

  */


    ~RTE_SecurityAttributes  ()
        {
            SAPDBTRACE_METHOD_DEBUG ("RTE_SecurityAttributes::~RTE_SecurityAttributes", Runtime_Trace, 9);
            Release ();
        }

  /*!
     @brief
     @param
     @return        none

  */

    void    Release ();

  /*!
     @brief
     @param
     @return        none

  */

    PSECURITY_ATTRIBUTES const  GetLockSA()
        {
            SAPDBTRACE_METHOD_DEBUG ("RTE_SecurityAttributes::GetLockSA", Runtime_Trace, 9);
            return &m_LockSA;
        }

  /*!
     @brief
     @param
     @return        none

  */

    PSECURITY_ATTRIBUTES const  GetWorldSA()
        {
            SAPDBTRACE_METHOD_DEBUG ("RTE_SecurityAttributes::GetWorldSA", Runtime_Trace, 9);
            return &m_WorldSA;
        }

  /*!
     @brief         Sets the security of an object to locked (no further open of the object
                    is possible).
     @param         hObject [in]            -   Handle from Object to be locked
     @param         messageList [in/out]    -   Message list
     @return        true/false

  */

    SAPDB_Bool  Lock            (HANDLE const                       hObject,
                                 SAPDBErr_MessageList &             messageList) const;
private:

  /*!
     @brief          Constructor


     The Constructor is privat to this class to avoid instantiation outside 
     of the class.

  */

    RTE_SecurityAttributes   ()
//        :   m_WorldSA.lpSecurityDescriptor (NULL),
//            m_LockSA.lpSecurityDescriptor (NULL)
    {
        SAPDBTRACE_METHOD_DEBUG ("RTE_SecurityAttributes::RTE_SecurityAttributes", Runtime_Trace, 9);
    }

  /*!
     @brief     Initialize instance

     @param     messageList [in/out]    - Message list

     @return    true/false
  */

    SAPDB_Bool Initialize (SAPDBErr_MessageList        &   messageList);


    static  RTE_SecurityAttributes *     m_Instance; 


    SECURITY_ATTRIBUTES      m_WorldSA;
    SECURITY_ATTRIBUTES      m_LockSA;
}; 

#endif  /* NT only */
#endif  /* RTE_SECURITYATTRIBUTESNT_HPP */

