/****************************************************************************/
/*!

  @file        SysView_MemoryHolders.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "MemoryHolders" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "hsp77.h"
#include "hak40.h"
#include "liveCache/MemoryManagement/LVCMem_Allocator.hpp"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_MemoryHolders.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_MemoryHolders::Create()
{

	m_Table->AppendCol (ITOCT_FIXED,     SV_CHUNKCOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED,     SV_CHUNKSIZE, 20);
	m_Table->AppendCol (ITOCT_LONGASCII, SV_CALLSTACK, 0);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_MemoryHolders::GetColCount()
{
	return SV_CC_MEMORYHOLDERS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_MemoryHolders::EstimateRows()
{
	return SV_ER_MEMORYHOLDERS;
}

/*---------------------------------------------------------------------------*/

void SysView_MemoryHolders::Execute()
{
    LVCMem_Allocator::SymbolVector::Iterator    iSymbolVec;
    SAPDB_UInt4                                 ChunkCount;
    SAPDB_UInt4                                 ChunkSize;
    SAPDB_Int                                   CallStackID;
    LVCMem_Allocator::SymbolVector              Symbols(LVCMem_Allocator::LVCAllocatorInstance());
    tgg00_Rec                                   LongRec;
    SAPDB_Char                                  format[12];
    SAPDB_Char                                  formatWithOffset[20];
    SAPDB_Char                                  *pCurrentLine;


    #if defined(BIT64)
        strcpy(format, "0x%016lx %s");
    #else
        strcpy(format, "0x%08lx %s");
    #endif

    strcpy(formatWithOffset, format);
    strcat(formatWithOffset, " + 0x%x");

    m_Table->GetCatalogTable();

    if (m_Context.IsOk())
    {
        for (LVCMem_Allocator::ContentIterator iContent = LVCMem_Allocator::LVCAllocatorInstance().Begin(); iContent; ++iContent)
        {

            iContent.Current (ChunkCount, ChunkSize, CallStackID, Symbols);

            m_Table->MoveToCol (ITOVT_UINT4, &ChunkCount, 0);
            m_Table->MoveToCol (ITOVT_UINT4, &ChunkSize, 0);

            LongRec.recLen_gg00() = cgg_rec_key_offset + sizeof (m_Table->GetPascalObjPtr()->a4LongKey);

            for (iSymbolVec = Symbols.Begin(); iSymbolVec != Symbols.End(); ++iSymbolVec)
            {
                pCurrentLine = (char *) &LongRec.recBuf_gg00()[LongRec.recLen_gg00()];

                if (iSymbolVec->m_offset < 0)
                {
                    sp77sprintf (pCurrentLine, 
                        sizeof(LongRec) - LongRec.recLen_gg00(),
                        format,
                        (SAPDB_Long)((char *)iSymbolVec->m_pcAddr - (char *)0),
                        iSymbolVec->m_pSymb);
                }
                else
                {
                    sp77sprintf (pCurrentLine, 
                        sizeof(LongRec) - LongRec.recLen_gg00(),
                        formatWithOffset,
                        (SAPDB_Long)((char *)iSymbolVec->m_pcAddr - (char *)0),
                        iSymbolVec->m_pSymb,
                        iSymbolVec->m_offset);
                }

                LongRec.recLen_gg00() += (SAPDB_Int)strlen(pCurrentLine);
                LongRec.recBuf_gg00()[LongRec.recLen_gg00()  ] = 13;
                LongRec.recBuf_gg00()[LongRec.recLen_gg00()+1] = 10;
                LongRec.recLen_gg00() += 2;
            }

            const int offset = cgg_rec_key_offset + sizeof (m_Table->GetPascalObjPtr()->a4LongKey);
            m_Table->MoveToLongColContainer (&LongRec.recBuf_gg00()[offset], LongRec.recLen_gg00() - offset);
        }
    }
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
