#ifndef XMLQCLIB_SESSION_EMBEDDED_H
#define XMLQCLIB_SESSION_EMBEDDED_H

/*!**********************************************************************

  module: XMLQCLib_SessionEmbedded.h

  -----------------------------------------------------------------------

  responsible:  Daniel Kirmse (D027470 - Daniel.Kirmse@SAP.com)

  special area: WebDAV / XML Indexing

  description:  Point of entry for WebDAV embedded XML Html Modelling GUI

  see also:		/

  -----------------------------------------------------------------------

  copyright:                (c) 2000-2004 SAP AG

************************************************************************/


	/*===================================================================
	// Includes
	//===================================================================*/
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_Common_TextConstants.h"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_Common_Utils.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_InitialFrameEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_HeaderEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_NavigationEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_ClientQuery.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_FreeQuery.hpp"
	

	/*===================================================================
	// Defines
	//===================================================================*/
	void sendInitialFrameQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendHeaderQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendMessageQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendNavigationQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendClientQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendFreeQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep, XMLQSLib_Handle qs, XMLIMAPI_Handle xml);

#endif