/*!
 * \file    LVC_SingleFileObjKeyIterator.cpp
 * \author  MarkusS
 * \brief   key range iterator to access non-partitioned key objects
 */		

/*
  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end

*****************************************************************************/


#ifndef LVC_SINGLEFILEOBJKEYITERATOR_HPP
#define LVC_SINGLEFILEOBJKEYITERATOR_HPP

 

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "liveCache/LVC_AbstractObjKeyIterator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "liveCache/LVC_KeyOIdQueue.hpp"


/*!*****************************************************************************
   class:        LVC_SingleFileObjKeyIterator
   description:  This class implements a key range iterator for object files 
*******************************************************************************/
class LVC_SingleFileObjKeyIterator : public LVC_AbstractObjKeyIterator
{
public:
  /*!-------------------------------------------------------------------------
	function:     IsEmpty()
	description:  returns true if the end of the iterator scope is reached
		   
	arguments:    none
	return value: (SAPDB_Bool) true if the end of the iterator scope is reached
    --------------------------------------------------------------------------*/
  virtual SAPDB_Bool IsEmpty() 
	{
		return m_NoMoreOIds;
	}

	/*!-------------------------------------------------------------------------
	function:     GetNextOIds();
	description:  see LVC_AbstractObjKeyIterator::GetNextOIds()
  --------------------------------------------------------------------------*/
	virtual void GetNextOIds(void            *pRestartKey, 
                           tgg92_KernelOid *pOId, 
                           tsp00_Int4      &noOfOid, 
                           SAPDB_Bool       bInclusive);

	/*!-------------------------------------------------------------------------
	function:     GetPrevOIds();
	description:  see LVC_AbstractObjKeyIterator::GetPrevOIds()
  --------------------------------------------------------------------------*/
	virtual void GetPrevOIds(void            *pRestartKey, 
                           tgg92_KernelOid *pOId, 
                           tsp00_Int4      &noOfOid, 
                           SAPDB_Bool       bInclusive);

	/*!-------------------------------------------------------------------------
	function:     ChangeDirection();
	description:  see LVC_AbstractObjKeyIterator::ChangeDirection()
  --------------------------------------------------------------------------*/
	virtual void ChangeDirection(void *m_pRestartKey, SAPDB_Bool bAscendingKeyOrder);

	/*!-------------------------------------------------------------------------
	function:     constructor()
	description:  
  --------------------------------------------------------------------------*/
	LVC_SingleFileObjKeyIterator (tgg00_TransContext     &Trans,
                                tgg00_FileId           &ObjFileId,
                                tsp00_Int4              KeyLen,
                                void                   *pStartKey,
                                void                   *pLowerKey,   
                                void                   *pUpperKey,       
                                SAPDBMem_IRawAllocator &Allocator,
                                bool                    bAscendingKeyOrder); 

	/*!-------------------------------------------------------------------------
	function:     destructor()
	description:  releases all resources and mark the iterator as destroyed via the checknumber
  --------------------------------------------------------------------------*/
	~LVC_SingleFileObjKeyIterator()
	{
	  SAPDBERR_ASSERT_STATE (IsValid());

		m_CheckNumber = 0;
	}

  /*!-------------------------------------------------------------------------*/

private: // member

	SAPDBMem_IRawAllocator  &m_Allocator;
	tsp00_Int4               m_ObjKeyFileIndex;
  tgg00_ObjFileNo          m_ObjFileNo;
	tsp00_Int4               m_CheckNumber;
	SAPDB_Bool               m_NoMoreOIds;
  tsp00_Key                m_LastKey;             // PTS 1119480

	static const tsp00_Int4  m_StaticCheckNumber;
};

/*!*****************************************************************************

   endclass: LVC_SingleFileObjKeyIterator

*******************************************************************************/


#endif  /* LVC_SINGLEFILEOBJKEYITERATOR_HPP */
