/*!
 * \file    LVCMem_UserAllocator.hpp
 * \author  IvanS
 * \brief   LiveCache user allocator (for session-specific memory).
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#ifndef __LVCMEM_USERALLOCATOR_HPP
#define __LVCMEM_USERALLOCATOR_HPP

#include "liveCache/MemoryManagement/LVCMem_UserAllocatorBase.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_RawAllocator.hpp"
#include "Oms/OMS_CallbackInterface.hpp"

class LVCMem_UserAllocator : public SAPDBMem_RawAllocator, public LVCMem_UserAllocatorBase
{
public:
  LVCMem_UserAllocator(
    const SAPDB_UTF8       *   Identifier,
    SAPDBMem_IRawAllocator &   RawAllocator,
    SAPDB_ULong                FirstBlockSize,
    SAPDB_ULong                SupplementBlockSize,
    FreeRawExtendsEnum         FreeRawExtends,
    SAPDB_ULong                MaxSize = GB4);

  virtual void *omsAllocate(size_t size);
  virtual void omsDeallocate(void *p);
  virtual bool omsCheckAllocatorEmpty();
  virtual int omsGetAllocatorType() const;

protected:
  friend class LVCMem_CheckedUserAllocator;

  /*!
   * \todo Remove this method and use memory debugger's callbacks instead, when implemented.
   */
  void memLeftOver(const void *blk, SAPDB_ULong stack, size_t size, OmsCallbackInterface::BlockType blockType);
  /*!
   * \todo Remove this method and use memory debugger's callbacks instead, when implemented.
   */
  void memInvalidFree(const void *blk, SAPDB_ULong stack, size_t size, OmsCallbackInterface::BlockType blockType, OmsCallbackInterface::BlockType freeType);
};

#endif  // __LVCMEM_USERALLOCATOR_HPP