/*!
  @file           veo964.cpp
  @author         JoergM
  @special area   ping
  @brief          Ping to vserver / niserver
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/




/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include <stdio.h>
#include "gsp00.h"
#include "gsp01.h"
#include "geo03.h"
#include "heo03.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

#define MAX_LINE_LEN 80
/*-----------------------------------------------------------*/
static void ShowAndRemoveNiErrorTrace (int ShowBeforeRemove )
/*-----------------------------------------------------------*/
{
  tsp00_Pathc NiErrorTrace ;

  eo03NiBuildTracefileName  (NiErrorTrace) ;

  if ( ShowBeforeRemove )
  {
    FILE *stream = fopen ( NiErrorTrace, "r" ) ;
    if ( stream != (FILE *) NULL )
    { 
        char line[ MAX_LINE_LEN + 1 ] ;
        bool ShowOk ;
        do
          if ( (ShowOk = fgets ( line, MAX_LINE_LEN , stream ) != NULL) )
            printf ("%s", line ) ;
        while ( ShowOk ) ;
        fclose ( stream ) ;
    }
  else
    { perror ( "open error" ) ;
      printf ( "missing NiErrorTrace  >%s<", (char *) NiErrorTrace ) ;
    }
  }

  /* Remove Tracefile */
  unlink(NiErrorTrace);

  return ;
}

/*-----------------------------------------------------------*/
int main ( int argc, char ** argv )
/*-----------------------------------------------------------*/
{
    int rc ;  
    if ( argc == 2 && argv[1] != NULL && *(argv[1]) != '0' )
    {
        tsp00_ErrTextc    ErrTextC; 
        tsp00_Versionc    ServerVersion;

        ServerVersion[0] = '\0' ;

        printf("\nChecking connection to '%s' ... ", argv[1] );
        if ( SqlAPing ( argv[1], ServerVersion, ErrTextC ) == commErrOk_esp01 )
        {
            printf("ok.\n\n");
            printf("Version of Server is\n");
            printf("----------------------------------------------------------\n");
            printf("%s\n", ServerVersion[0] != '\0' ? (char *)ServerVersion : "UNKNOWN");
            printf("----------------------------------------------------------\n");
            rc = 0 ;
        }
        else
        {
            printf("ERROR\n\n");
            printf("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
            printf("Problem: %s\n\n", (char *)ErrTextC );
            printf("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
            rc = 1 ;
        }
        if ( SqlIsSaprouterString (argv[1]) ) 
          ShowAndRemoveNiErrorTrace(rc);
    }
    else
      printf("\nUSAGE: %s <hostname / saprouter string>\n", argv[0]);

    return (rc);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
