
/*******************************************************************************
*
* module:       hgg05.h
*
* ------------------------------------------------------------------------------
*
* responsible:  nn
*
* lastChanged:  1999-09-15
*
* purpose:      Configuration_Parameter
*
* generatedBy:  Holger Becker
*
* ------------------------------------------------------------------------------
*
* Copyright (c) 1999-2004 SAP AG
*


    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

********************************************************************************/

// PTS 1103975 JA 1999-09-15

#ifndef HGG05_H
#define HGG05_H


/*****************************************************
 *     RefType: C++
 *****************************************************/



/*****************************************************
 *     I N C L U D E S                               *
 *****************************************************/

#include "ggg00.h"
#include "hgg10.h"

#ifndef SUN
#include <memory.h>
#endif /* SUN */

inline void 
gg05KeyAssign (const tsp00_KeyPtr   pSourceKey,
			   tsp00_Int4           SourceKeyLen,
			   tsp00_KeyPtr         pTargetKey,
		       tsp00_Int2          &TargetKeyLen,
			   tgg00_BasisError    &TrError)
{
	if ( SourceKeyLen >= 0 || SourceKeyLen <= sizeof (tsp00_Key) )
	{
		if (SourceKeyLen > 0)
		{
			TargetKeyLen = SourceKeyLen;
			memcpy( pTargetKey, pSourceKey, TargetKeyLen);
		}
		else
			TargetKeyLen = 0;
	}
	else
      g10mv_err_handling ("HGG05 ", 1, sizeof (tsp00_Key), sizeof (tsp00_Key),
		   1, 1, SourceKeyLen, &TrError);
}

/*****************************************************
 *     P R O T O T Y P E S                           *
 *****************************************************/

#endif

