/*!**************************************************************************

    module      : vkb611.cpp

    -------------------------------------------------------------------------

    author      : JuergenA
    responsible : UweH

    special area: Logging
    description : KB_InsDelUpd_interface

    last changed: 2001-04-12

    -------------------------------------------------------------------------

    copyright:    (c) 2001-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/SAPDB_Types.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "Logging/Log_CommandInsDelUpd.hpp"
#include "Logging/Log_InvDescMap.hpp"
#include "gsp00.h"
#include "ggg00.h"
#include "hkb611.h" // check of PASCAL header vkb611

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*==========================================================================*
* LOCAL FUNCTIONS                                                           *
*===========================================================================*/


/*==========================================================================*
* PASCAL INTERFACE of Log_DeleteCmd                                         *
*===========================================================================*/

externPascal void kb611del_AllocateClass (Log_DeleteCmd         *&pDeleteCmd,
                                          tgg00_TransContext     &TransContext,
                                          const tgg00_StackDesc  &StackDesc)
{
    if (e_ok != TransContext.trError_gg00) return;
    
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    pDeleteCmd = new (Allocator) Log_DeleteCmd;
    
    if (NULL == pDeleteCmd)
    {
        TransContext.trError_gg00 = e_no_more_memory;
        return;
    }
    
    pDeleteCmd->AssignInvDescMap (StackDesc);
}

//----------------------------------------------------------------------------

externPascal void kb611del_Init (Log_DeleteCmd      *pDeleteCmd,
                                 const tgg00_FileId &PrimFileId,
                                 const tgg00_Rec    &OldRecord)
{
    pDeleteCmd->Init (PrimFileId, &OldRecord);
}

//----------------------------------------------------------------------------

externPascal void kb611del_PostponedExecution (const Log_DeleteCmd *pDeleteCmd,
                                               tgg00_TransContext  &TransContext,
                                               tgg00_FileId        &PrimFileId)
{
    pDeleteCmd->PostponedExecution (TransContext, PrimFileId);
}

//----------------------------------------------------------------------------

externPascal void kb611del_ReleaseClass (Log_DeleteCmd          *&pDeleteCmd,
                                         SAPDBMem_IRawAllocator  *pAllocator)
{ 
    if ( NULL == pDeleteCmd ) return;
    
    destroy (pDeleteCmd, *pAllocator);
    
    pDeleteCmd = NULL;
}

//----------------------------------------------------------------------------

externPascal void kb611del_WriteAfterImage (const Log_DeleteCmd *pDeleteCmd,
                                            tgg00_TransContext  &TransContext)
{
    pDeleteCmd->WriteAfterImage (TransContext);
}

//----------------------------------------------------------------------------

externPascal void kb611del_WriteBeforeImage (const Log_DeleteCmd *pDeleteCmd,
                                             tgg00_TransContext  &TransContext)
{
    pDeleteCmd->WriteBeforeImage (TransContext);
}


/*==========================================================================*
* PASCAL INTERFACE index handling                                           *
*===========================================================================*/

externPascal void kb611IndexGetKey (
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_StEntryAddr                    pStackList,
    tsp00_Int2                           Entries,
    const tgg00_Rec       VAR_VALUE_REF  Rec,
    tsp00_Uint1           VAR_VALUE_REF  InvDescId,
    tgg00_Lkey            VAR_VALUE_REF  SecondaryKey,
    pasbool               VAR_VALUE_REF  allColumnsAreNull) // PTS 1121337 UH 2003-03-27
{
    Log_InvDescMap InvDescMap;
    
    InvDescMap.Assign (
        pStackList, abs (Entries),
        false); // do not LookForUniqueEntries

    bool aux = false;
    InvDescMap.GetFirstKey (TransContext, &Rec, InvDescId, SecondaryKey, aux); // PTS 1121337 UH 2003-03-27
    allColumnsAreNull = aux;
}


/*==========================================================================*
* PASCAL INTERFACE of Log_InsertCmd                                         *
*===========================================================================*/

externPascal void kb611ins_AllocateClass (Log_InsertCmd         *&pInsertCmd,
                                          tgg00_TransContext     &TransContext,
                                          const tgg00_StackDesc  &StackDesc)
{
    if (e_ok != TransContext.trError_gg00) return;
    
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    pInsertCmd = new (Allocator) Log_InsertCmd;
    
    if (NULL == pInsertCmd)
    {
        TransContext.trError_gg00 = e_no_more_memory;
        return;
    }
    
    pInsertCmd->AssignInvDescMap (StackDesc);
}

//----------------------------------------------------------------------------

externPascal void kb611ins_Init (Log_InsertCmd      *pInsertCmd,
                                 const tgg00_FileId &PrimFileId,
                                 const tgg00_Rec    &NewRecord)
{
    pInsertCmd->Init (PrimFileId, &NewRecord);
}

//----------------------------------------------------------------------------

externPascal void kb611ins_ReleaseClass (Log_InsertCmd          *&pInsertCmd,
                                         SAPDBMem_IRawAllocator  *pAllocator)
{ 
    if ( NULL == pInsertCmd ) return;
    
    destroy (pInsertCmd, *pAllocator);
    
    pInsertCmd = NULL;
}

//----------------------------------------------------------------------------

externPascal void kb611ins_WriteAfterImage (const Log_InsertCmd *pInsertCmd,
                                            tgg00_TransContext  &TransContext)
{
    pInsertCmd->WriteAfterImage (TransContext);
}

//----------------------------------------------------------------------------

externPascal void kb611ins_WriteBeforeImage (const Log_InsertCmd *pInsertCmd,
                                             tgg00_TransContext  &TransContext)
{
    pInsertCmd->WriteBeforeImage (TransContext);
}


/*==========================================================================*
* PASCAL INTERFACE of Log_InvHandling                                       *
*===========================================================================*/

externPascal void kb611inv_AddInv (const Log_InvHandling *pInvHandling,
                                   tgg00_TransContext    &TransContext)
{
    pInvHandling->AddInv (TransContext);
}

//----------------------------------------------------------------------------

externPascal void kb611inv_CheckUniqueIndex (const Log_InvHandling *pInvHandling,
                                             tgg00_TransContext    &TransContext)
{
    pInvHandling->CheckUniqueIndex (TransContext);
}

//----------------------------------------------------------------------------

externPascal pasbool kb611inv_ContainsLateUniqueCheck (const Log_InvHandling *pInvHandling)
{
    return ( pInvHandling->ContainsLateUniqueCheck() );
}

//----------------------------------------------------------------------------

externPascal pasbool kb611inv_ContainsUniqueIndex (const Log_InvHandling *pInvHandling)
{
    return ( pInvHandling->ContainsUniqueIndex() );
}

//----------------------------------------------------------------------------

externPascal void kb611inv_DelInv (const Log_InvHandling *pInvHandling,
                                   tgg00_TransContext    &TransContext)
{
    pInvHandling->DelInv (TransContext);
}

//----------------------------------------------------------------------------

externPascal pasbool kb611inv_ExecuteOutsideBd (Log_InvHandling *pInvHandling)
{
    return ( pInvHandling->ExecuteOutsideBd() );
}

//----------------------------------------------------------------------------

externPascal pasbool kb611inv_ExistsAnyIndex (const Log_InvHandling *pInvHandling)
{
    return ( pInvHandling->ExistsAnyIndex() );
}

//----------------------------------------------------------------------------

externPascal pasbool kb611inv_IsExecutionPostponed (const Log_InvHandling *pInvHandling)
{
    return ( pInvHandling->IsExecutionPostponed() );
}

//----------------------------------------------------------------------------

externPascal void kb611inv_LockAndCheckUniqueIndex (const Log_InvHandling *pInvHandling,
                                                    tgg00_TransContext    &TransContext,
                                                    tgg00_LockReqMode     &GrantedMode)
{
    pInvHandling->LockAndCheckUniqueIndex (TransContext, GrantedMode);
}

//----------------------------------------------------------------------------

externPascal void kb611inv_LockUniqueBeforeImageIndex (const Log_InvHandling *pInvHandling,
                                                       tgg00_TransContext    &TransContext,
                                                       tgg00_LockReqMode     &GrantedMode)
{
    const bool BeforeImageOnly = true;
    
    pInvHandling->LockUniqueIndex (TransContext, GrantedMode, BeforeImageOnly);
}

//----------------------------------------------------------------------------

externPascal void kb611inv_LockUniqueIndex (const Log_InvHandling *pInvHandling,
                                            tgg00_TransContext    &TransContext,
                                            tgg00_LockReqMode     &GrantedMode)
{
    pInvHandling->LockUniqueIndex (TransContext, GrantedMode);
}


/*==========================================================================*
* PASCAL INTERFACE of Log_UpdateCmd                                         *
*===========================================================================*/

externPascal void kb611upd_AllocateClass (Log_UpdateCmd         *&pUpdateCmd,
                                          tgg00_TransContext     &TransContext,
                                          const tgg00_StackDesc  &StackDesc)
{
    if (e_ok != TransContext.trError_gg00) return;
    
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    pUpdateCmd = new (Allocator) Log_UpdateCmd;
    
    if (NULL == pUpdateCmd)
    {
        TransContext.trError_gg00 = e_no_more_memory;
        return;
    }
    
    pUpdateCmd->AssignInvDescMap (StackDesc);
}

//----------------------------------------------------------------------------

externPascal void kb611upd_AllocateColumnMap (Log_UpdateCmd      *pUpdateCmd,
                                              tgg00_TransContext &TransContext, 
                                              tsp00_Int4          MaxEntries)
{
    if (e_ok != TransContext.trError_gg00) return;
    
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    bool IsOk = true;
    
    pUpdateCmd->AllocateColumnMap (Allocator, MaxEntries, IsOk);
    
    if ( ! IsOk ) TransContext.trError_gg00 = e_no_more_memory;
}

//----------------------------------------------------------------------------

externPascal void kb611upd_CreateNewRec (Log_UpdateCmd      *pUpdateCmd,
                                         tgg00_TransContext &TransContext,
                                         const tgg00_FileId &PrimFileId,
                                         const tgg00_Rec    &OldRecord,
                                         tgg00_Rec          &NewRecord)
{
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    pUpdateCmd->CreateNewRec
        (Allocator, PrimFileId, &OldRecord, &NewRecord, sizeof (NewRecord), TransContext.trError_gg00);
}

//----------------------------------------------------------------------------

externPascal pasbool kb611upd_ExistsEntry (Log_UpdateCmd          *pUpdateCmd,
                                           const tgg00_StackEntry &StackEntry)
{
    return ( pUpdateCmd->ExistsEntry (StackEntry) );
}

//----------------------------------------------------------------------------

externPascal void kb611upd_InitAfterImageWithExistingNewRec (Log_UpdateCmd      *pUpdateCmd,
                                                             const tgg00_FileId &PrimFileId,
                                                             const tgg00_Rec    &NewRecord)
{
    pUpdateCmd->InitAfterImageWithExistingNewRec (PrimFileId, &NewRecord);
}

//----------------------------------------------------------------------------

externPascal void kb611upd_InitBeforeImageForExistingNewRec (Log_UpdateCmd      *pUpdateCmd,
                                                             tgg00_TransContext &TransContext,
                                                             const tgg00_Rec    &OldRecord)
{
    SAPDBMem_IRawAllocator& Allocator =
        *(REINTERPRET_CAST (SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00));
    
    pUpdateCmd->InitBeforeImageForExistingNewRec (Allocator, &OldRecord, TransContext.trError_gg00);
}

//----------------------------------------------------------------------------

externPascal void kb611upd_InsertColumn (Log_UpdateCmd          *pUpdateCmd,
                                         const tgg00_StackEntry &StackEntry,
                                         const tsp00_BytePtr     pValue,
                                         tsp00_Int4              ValueLength,
                                         tgg00_BasisError       &Error)
{
    pUpdateCmd->InsertColumn (StackEntry,  pValue, ValueLength, Error);
}

//----------------------------------------------------------------------------

externPascal void kb611upd_PostponedExecution (const Log_UpdateCmd *pUpdateCmd,
                                               tgg00_TransContext  &TransContext,
                                               tgg00_FileId        &PrimFileId)
{
    pUpdateCmd->PostponedExecution (TransContext, PrimFileId);
}

//----------------------------------------------------------------------------

externPascal void kb611upd_ReleaseClass (Log_UpdateCmd          *&pUpdateCmd,
                                         SAPDBMem_IRawAllocator  *pAllocator)
{ 
    if ( NULL == pUpdateCmd ) return;
    
    destroy (pUpdateCmd, *pAllocator);
    
    pUpdateCmd = NULL;
}

//----------------------------------------------------------------------------

externPascal void kb611upd_WriteAfterImage (const Log_UpdateCmd *pUpdateCmd,
                                            tgg00_TransContext  &TransContext)
{
    pUpdateCmd->WriteAfterImage (TransContext);
}

//----------------------------------------------------------------------------


externPascal void kb611upd_WriteBeforeImage (const Log_UpdateCmd *pUpdateCmd,
                                             tgg00_TransContext  &TransContext)
{
    pUpdateCmd->WriteBeforeImage (TransContext);
}

/*===========================================================================*
*  END OF CODE                                                               *
*============================================================================*/
