/*



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
%{
/*
  -----------------------------------------------------------------------------

  module: vls14_scan.l

  -----------------------------------------------------------------------------

  responsible:  SteffenS and d033893

  special area: SAP DB LOADER

  description:  scanner grammar

  version:      7.4.

  -----------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG-2003

  -----------------------------------------------------------------------------
*/

#include "vls14_parse_gen.h"    // by bison generated header-file containing token definitions
#include "hls07.h"
%}


/*
    ALLOWED CHARS FOR IDENTIFIER:

    first_char_in_identifier            a-z
    ------------------------            A-Z
                                        #$@
                                        ASCII (^= ISO 8859/1.2) 192-214, 216-222, 224-246, 248-254

    remaining_chars_in_identifier       a-z
    -----------------------------       A-Z
                                        #$@
                                        _
                                        digits
                                        ASCII (^= ISO 8859/1.2) 192-214, 216-222, 224-246, 248-254


    PASSWORD IDENTIFIER differ from INDENTIFIER in that they allow digits as first character
    Syntax for HOSTNAMES (DNS_NAME) is defined in RFC 1035 DNS_NAME corresponds to dns-domain)

*/

DIGIT           [0-9]
CHAR            [.]
LETTER          [a-zA-Z]
EXTENDED_LETTER [#@$]
LANG_SPEC_CHAR  [\300-\326\330-\336\340-\366\370-\376]
UNDERSCORE      [_]
HYPHEN          [-]
POINT           [.]

FIRST_CHAR            ({LETTER}|{EXTENDED_LETTER}|{LANG_SPEC_CHAR})
TAIL_CHAR             ({FIRST_CHAR}|{DIGIT}|{UNDERSCORE})
DB_IDENTIFIER         ({FIRST_CHAR})({TAIL_CHAR}*)
PW_IDENTIFIER         ({FIRST_CHAR}|{DIGIT})({TAIL_CHAR}*)
POINT_SEP_IDENTIFIER  ({DB_IDENTIFIER}{POINT}{DB_IDENTIFIER})

LET_DIG               ({LETTER}|{DIGIT})
LET_DIG_HYP           ({LET_DIG}|{HYPHEN})
DNS_TRAILER           ({LET_DIG_HYP}*)({LET_DIG})
DNS_LABEL             ({LETTER})({DNS_TRAILER}*)
DNS_LABEL_POINT       ({POINT}{DNS_LABEL})

DNS_NAME              ({DNS_LABEL}{DNS_LABEL_POINT}*)


THREE_DIGITS          ({DIGIT}{1,3})
POI_THR_DIG           ({POINT}{DIGIT}{1,3})
IP_ADDRESS            ({THREE_DIGITS})({POI_THR_DIG})({POI_THR_DIG})({POI_THR_DIG})


/* Begin of syntax definition ***********************************************************/
%%

[\/][\/][^\n]*    { /* Kommentar bis Zeilenende ueberlesen (Kommentarzeichen : "//") */
                    CopyToken("COMMENT");
                    IncreasePosition();
                }

[\00-\40]       {
                    /* Sonder- und Leerzeichen ueberlesen */
                    IncreasePosition();
                }

'[^'\\]*(\\.[^'\\]*)*'  {
                            CopyToken("SINGLE_QUOTED_STRING");  

                            ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                            ReturnStructure.C_String.strLeng_ls00 = yyleng; 

                            IncreasePosition();
                            yylex_return = dtSINGLE_QUOTED_STRING;
                        }

[\"][^\"]+[\"]  {
                    CopyToken("DOUBLE_QUOTED_STRING");

                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;

                    IncreasePosition();
                    yylex_return = dtDOUBLE_QUOTED_STRING;
                }

"("             {
                    CopyToken("OPEN");
                    IncreasePosition();
                    ReturnStructure.C_Char = yytext[0];
                    yylex_return = sgnOPEN;
                }

")"             {
                    CopyToken("CLOSE");
                    IncreasePosition();
                    ReturnStructure.C_Char = yytext[0];
                    yylex_return = sgnCLOSE;
                }

","             {
                    CopyToken("COMMA");
                    IncreasePosition();
                    yylex_return = sgnCOMMA;
                }

"."             {
                    CopyToken("POINT");
                    IncreasePosition();
                    yylex_return = sgnPOINT;
                }
":"             {
                    CopyToken("COLON");
                    IncreasePosition();
                    yylex_return = sgnCOLON;
                }

"'"             {
                    CopyToken("QUOTE");
                    IncreasePosition();
                    yylex_return = sgnQUOTE;
                }

"%"             {
                    CopyToken("PERCENT");
                    IncreasePosition();
                    yylex_return = sgnPERCENT;
                }


"-"             {
                    CopyToken("MINUS");
                    IncreasePosition();
                    yylex_return = opMI;
                }

"*"             {
                    CopyToken("MULT");
                    IncreasePosition();
                    yylex_return = opMU;
                }

"="             {
                    CopyToken("EQUAL");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = BLANK_LS00;
                    yylex_return = opEQ;
                }

"<"             {
                    CopyToken("SMALL");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = BLANK_LS00;
                    yylex_return = opSM;
                }

">"             {
                    CopyToken("LARGE");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = BLANK_LS00;
                    yylex_return = opLA;
                }

"<="            {
                    CopyToken("SMALL EQ");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = yytext[1];
                    yylex_return = opSE;
                }

">="            {
                    CopyToken("LARGE EQ");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = yytext[1];
                    yylex_return = opLE;
                }

"<>"            {
                    CopyToken("NOT EQ");
                    IncreasePosition();
                    ReturnStructure.C_Char2[0] = yytext[0];
                    ReturnStructure.C_Char2[1] = yytext[1];
                    yylex_return = opNE;
                }

"ADSM"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwADSM;
                }

"TSM"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwADSM;
                }

"ALL"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwALL;
                }

"AND"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwAND;
                }

"ANSI"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwANSI;
                }

"APPEND"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwAPPEND;
                }

"ASCII"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwASCII;
                }

"AUTOCOMMIT"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwAUTOCOMMIT;
                }

"BACK"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBACK;
                }

"BACKINT"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBACK;
                }

"BACKUPTOOL"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBACKUPTOOL;
                }

"BOOLEAN"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBOOLEAN;
                }

"BINARY"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBINARY;
                }

"BY"            {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwBY;
                }

"CATALOG"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCATALOG;
                }

"CATALOGEXTRACT" {
                     CopyToken("KEYWORD");
                     IncreasePosition();
                     yylex_return = kwCATALOGEXTRACT;
                }

"CATALOGLOAD"   {
                     CopyToken("KEYWORD");
                     IncreasePosition();
                     yylex_return = kwCATALOGLOAD;
                }

"CHAR"          {
                     CopyToken("KEYWORD");
                     IncreasePosition();
                      yylex_return = kwCHAR;
                }

"CODESET"       {
                     CopyToken("KEYWORD");
                     IncreasePosition();
                     yylex_return = kwCODESET;
                }

"CODETYPE"      {
                     CopyToken("KEYWORD");
                     IncreasePosition();
                     yylex_return = kwCODETYPE;
                }

"CODEPAGE"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCODEPAGE;
                }


"COMPACT"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCOMPACT;
                }

"COMPRESSED"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCOMPRESSED;
                }

"COUNT"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCOUNT;
                }

"CURRENT"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCURRENT;
                }

"DATA"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATA;
                }

"DATAEXTRACT"   {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATAEXTRACT;
                }

"DATALOAD"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATALOAD;
                }

"DATAUPDATE"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATAUPDATE;
                }

"DATE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATE;
                }
"DB"            {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwALL;
                }
"DB2"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDB2;
                }

"DBEXTRACT"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDBEXTRACT;
                }

"DBLOAD"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDBLOAD;
                }

"DDL"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDDL;
                }

"DECIMAL"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDECIMAL;
                }

"DEFAULT"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDEFAULT;
                }

"DELIMITER"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDELIMITER;
                }

"DUPLICATES"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDUPLICATES;
                }

"EBCDIC"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwEBCDIC;
                }

"EBID"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwEBID;
                }

"EUR"             {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwEUR;
                  }

"EXCLUDE"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwEXCLUDE;
                  }
"EXTRACT"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwEXTRACT;
                  }
"EXTRACT CATALOG" {   // Alternative to catalogextract
                        CopyToken("KEYWORD");
                        IncreasePosition();
                        yylex_return = kwCATALOGEXTRACT;
                  }

"EXTRACT DATA"  {  // Alternative to dataextract
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATAEXTRACT;
                }
"EXTRACT DB"    {  // Alternative to dbextract
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDBEXTRACT;
                }                
"EXTRACT TABLE" {   // Alternative to tableextract
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEEXTRACT;
                }
"FASTLOAD"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwFASTLOAD;
                }

"FILE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwFILE;
                }

"FOR"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwFOR;
                }

"FORMATTED"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwFORMATTED;
                }

"CONFIGURATION" {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCONFIGURATION;
                }

"HEX"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwHEX;
                }

"HILO"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwHILO;
                }

"IF"            {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwIF;
                }

"IGNORE"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwIGNORE;
                }

"INFILE"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwINFILE;
                }

"INSTREAM"      {   // alternative keyword
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwINFILE;
                }

"INTEGER"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwINTEGER;
                }

"INTERNAL"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwINTERNAL;
                }

"INSTALLATION"  {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwINSTALLATION;
                }

"ISO"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwISO;
                }

"JIS"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwJIS;
                }

"KEY"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwKEY;
                }

"LANGUAGE"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLANGUAGE;
                }
"LOAD"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLOAD;
                }
"LOAD CATALOG"  {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCATALOGLOAD;
                }

"LOAD DATA"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATALOAD;
                }

"LOAD DB"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDBLOAD;
                }

"LOAD FAST"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwFASTLOAD;
                }

"LOAD TABLE"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLELOAD;
                }
"LOGOWNER"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLOGOWNER;
                }
"REMARK"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwREMARK;
                }
"LOHI"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLOHI;
                }

"LONGFILE"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLONGFILE;
                }

"LONGSTREAM"    {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwLONGFILE;
                }

"MAXERRORCOUNT" {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwMAXERRORCOUNT;
                }

"MESSAGE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwMESSAGE;
                }

"NOHEADER"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNOHEADER;
                }

"NODATA"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNODATA;
                }
"NODDL"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNODDL;
                }

"NOLOG"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNOLOG;
                }

"NOT"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNOT;
                }

"NSR"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNSR;
                }

"NETWORKER"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNSR;
                }

"NULL"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNULL;
                }

"NUMBER"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwNUMBER;
                }

"ODBCTRACE"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwODBCTRACE;
                }

"OR"            {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOR;
                }

"OFF"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOFF;
                }

"ON"            {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwON;
                }

"ORACLE"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwORACLE;
                }

"ORDER"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwORDER;
                    }

"OTHERWISE"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOTHERWISE;
                }

"OUTFILE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOUTFILE;
                }

"OUTFIELDS"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOUTFIELDS;
                }

"OUTSTREAM"     {   // alternative keyword
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwOUTFILE;
                }

"PACKAGE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwPACKAGE;
                }

"PAGE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwPAGE;
                }

"PAGES"         {   //alternative keyword
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwPAGE;
                }

"PIPE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwPIPE;
                }

"POS"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwPOS;
                }

"REAL"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwREAL;
                }

"RECORDS"       {   // alternative keyword
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwCOMPACT;
                }

"REJECT"        {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwREJECT;
                }

"RELEASE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    RepCommand->cmdSubFunc_ls00 = sfRelease_els00;
                    yylex_return = kwRELEASE;
                }

"RESTART"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwRESTART;
                }

"ROUND"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwROUND;
                }

"ROWS"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwROWS;
                }

"SCALE"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSCALE;
                }

"SEPARATOR"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSEPARATOR;
                }

"SEQNO"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSEQNO;
                }

"SERVERDB"      {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSERVERDB;
                }

"SET"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSET;
                }

"SIZE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSIZE;
                }

"SQLID"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSQLID;
                }

"SQLMODE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSQLMODE;
                }

"STAMP"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSTAMP;
                }

"START"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSTART;
                }

"SYSDATE"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwSYSDATE;
                }

"TABLE"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLE;
                }

"TABLEEXTRACT"  {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEEXTRACT;
                }

"TABLELOAD"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLELOAD;
                }
                
"TABLEFASTLOAD" {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEFASTLOAD;
                }

"TABLEUNLOAD"   {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEUNLOAD;
                }

"TABLEUPDATE"   {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEUPDATE;
                }

"TAPE"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTAPE;
                }

"TIME"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTIME;
                }

"TIMESTAMP"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTIMESTAMP;
                }

"TRANSACTION"   {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTRANSACTION;
                }

"TRUNC"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTRUNC;
                }

"UCS2"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUCS2;
                }

"UID"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUID;
                }

"UNLOAD TABLE"  {   // Alternative to tableupdate
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEUNLOAD;
                }

"UPDATE"/[\00-\40]*"DUPLICATES" {
/* update wird nur dann als schluesselwort erkannt, wenn ihm beliebig viele sonderzeichen
   und das wort 'duplicates' folgen, wobei die auf update folgenden zeichen zwar
   vorausgelesen aber nicht in yytext gespeichert werden, somit als noch nicht gelesen
   gelten.
   Zusammen ergibt 'update duplicates' einen teil der dataload-anweisung.
   Update allein wird als unbekanntes schluesselwort interpretiert und als sql-kommando
   abgearbeitet
*/
                                    CopyToken("KEYWORD");
                                    IncreasePosition();
                                    yylex_return = kwUPDATE;
                                }

"UPDATE DATA"   {   // Alternative to dataupdate
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwDATAUPDATE;
                }

"UPDATE TABLE"  {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwTABLEUPDATE;
                }

"USA"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSA;
                }

"USAGE"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSAGE;
                }

"USE"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSE;
                }
"USER"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSER;
                }
"USERGROUP"     {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSERGROUP;
                }

"USERKEY"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUSERKEY;
                }
"UTF8"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwUTF8;
                }

"VERSION"       {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwVERSION;
                }


"WITH"          {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwWITH;
                }

"XML"           {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwXML;
                }

"ZONED"         {
                    CopyToken("KEYWORD");
                    IncreasePosition();
                    yylex_return = kwZONED;
                }

{DIGIT}+        {
                    CopyToken("INTEGER_LITERAL");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtINTEGER_LITERAL;
                }


{DB_IDENTIFIER} {
                    CopyToken("DB_IDENTIFIER");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtDB_IDENTIFIER;
                }

{PW_IDENTIFIER} {
                    CopyToken("PW_IDENTIFIER");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtPW_IDENTIFIER;
                }

{POINT_SEP_IDENTIFIER}  {
                            CopyToken("POINT_SEP_IDENTIFIER");
                            ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                            ReturnStructure.C_String.strLeng_ls00 = yyleng;
                            IncreasePosition();
                            yylex_return = dtPOINT_SEP_IDENTIFIER;
                        }

{DNS_NAME}      {
                    CopyToken("DNS_NAME");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtDNS_NAME;
                }

{IP_ADDRESS}    {
                    CopyToken("IP_ADDRESS");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtIP_ADDRESS;
                }

{CHAR}+         {
                    CopyToken("STRING");
                    ReturnStructure.C_String.strAddr_ls00 = &RepCommand->cmdReqDat_ls00[RepCommand->cmdReqPos_ls00];
                    ReturnStructure.C_String.strLeng_ls00 = yyleng;
                    IncreasePosition();
                    yylex_return = dtSTRING;
                }

.               {
                    CopyToken("CHAR");
                    IncreasePosition();
                    ReturnStructure.C_Char = yytext[0];
                    yylex_return = dtCHAR;
                }

%%
/* End of syntax definition *************************************************************/
