/*!**********************************************************************

  module: vls32_dbextract.cpp

  -----------------------------------------------------------------------

  responsible:  d033893

  special area: SAP DB LOADER

  description:  Implementation of the DBEXTRACT/DBLOAD functionality

  version:      7.4.

  -----------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "hls98msg.h"
#include "hls11.h"
#include "hls15.h"
#include "hls26.h"                 // ls26ExecTableExtract
#include "hls28_TLoad.h"           // ls28ExecTableLoad
#include "hls31_catalogextract.h"  // ls31ExecCatalogExtract
#include "hls33_backup.h"
#include "hls32_dbextract.h"       // ls31ExecCatalogLoad

/* -----------------------------------------------------------------------------
   ls32ExecDBPartTransformation
/-------------------------------------------------------------------------------*/
SAPDB_Int4 ls32ExecDBPartTransformation( tls00_Command    *pTransformationCmd,
								         tls00_DBInfo     *pDBInfo,
								         tsp00_Addr        ErrText)
{
	  ROUTINE_DBG_MEO00 ("ls32ExecDBPartTransformation");

	  RepServMessages  *pMsgInstance  = RepServMessages::Instance();

	  SAPDB_Int4  rc = errOK_els00;

	  Tools_DynamicUTF8String  metadatatransformation;
	  Tools_DynamicUTF8String  tablename;
	  Tools_DynamicUTF8String  metadatastream;
	  Tools_DynamicUTF8String  metadatastreamebid;
	  Tools_DynamicUTF8String  datatransformation;
	  Tools_DynamicUTF8String  datastream;
	  Tools_DynamicUTF8String  datastreamebid;
	  Tools_DynamicUTF8String  configuration;
	  Tools_DynamicUTF8String  package;

	  switch(pTransformationCmd->cmdScanRC_ls00)
      {
		    case srFctDBPartExtr_els00:
            {
			     tls00_DBPartExtrCmd* pDBPartExtrCmd = REINTERPRET_CAST (tls00_DBPartExtrCmd*, pTransformationCmd->cmdScnDat_ls00);
				 //*
				 //* Authorization
				 //*
				 if ( pDBPartExtrCmd->dbpePartSpec_ls00.psPartType_ls00 == ptAll_els00 )
				 {
					rc = ls15CheckUserMode(pDBInfo, pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(), dbuSysdba_els00, ErrText);
					if (errOK_els00 != rc)
					{
						if (dbRowNotFound_els00 == rc)
						{
							pMsgInstance->ls98Msg(layDBExtract_els98, ErrText, errRestrictedStmt_els98);
						}
						return rc;
					}
				 }
				 //*
				 //* Relational
				 //*
				 if ( NULL != pDBPartExtrCmd->dbpeCatfile_ls00.fsFileName_ls00 )
				 {
					metadatatransformation  = "EXTRACT CATALOG ";
					metadatatransformation +=  pszPartTypeName_ls00[pDBPartExtrCmd->dbpePartSpec_ls00.psPartType_ls00];
					metadatatransformation += " ";

					if ( pDBPartExtrCmd->dbpePartSpec_ls00.psPartType_ls00 == ptTable_els00 )
						metadatatransformation += tablename.AssignRaw(REINTERPRET_CAST(unsigned char*, pDBPartExtrCmd->dbpePartSpec_ls00.psFullTabName_ls00),
																								_tcslen(pDBPartExtrCmd->dbpePartSpec_ls00.psFullTabName_ls00));

					metadatastream.ConvertFromASCII_Latin1( pDBPartExtrCmd->dbpeCatfile_ls00.fsFileName_ls00,
															pDBPartExtrCmd->dbpeCatfile_ls00.fsFileName_ls00 +
													_tcslen(pDBPartExtrCmd->dbpeCatfile_ls00.fsFileName_ls00));

					metadatatransformation += " OUTSTREAM ";
					metadatatransformation += pszDeviceTypeName_ls00[pDBPartExtrCmd->dbpeCatfile_ls00.fsDeviceType_ls00];
					metadatatransformation += "'";
					metadatatransformation += metadatastream;
					metadatatransformation += "'";

					if ( pDBPartExtrCmd->dbpeCatfile_ls00.fsFormat_ls00.ffoDdl_ls00 == true )
						metadatatransformation += " DDL ";
					if ( pDBPartExtrCmd->dbpeCatfile_ls00.fsFormat_ls00.ffoXml_ls00 == true )
						metadatatransformation += " XML ";
					if ( pDBPartExtrCmd->dbpeRestart_ls00.rstRestart_ls00 == true  )
					{
						metadatatransformation += " RESTART ";
						metadatatransformation += "'";
						metadatatransformation += pDBPartExtrCmd->dbpeRestart_ls00.rstPackageid_ls00;
						metadatatransformation += "'";
					}
					metadatatransformation += " INTERNAL ";
				 }
				 if ( NULL != pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00 ||
					  NULL != pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00 )
				 {
					datatransformation  = "EXTRACT TABLE ";
   					datatransformation +=  pszPartTypeName_ls00[pDBPartExtrCmd->dbpePartSpec_ls00.psPartType_ls00];
					datatransformation += " ";

				    if ( pDBPartExtrCmd->dbpePartSpec_ls00.psPartType_ls00 == ptTable_els00 )
					 	 datatransformation += tablename.AssignRaw(REINTERPRET_CAST(unsigned char*, pDBPartExtrCmd->dbpePartSpec_ls00.psFullTabName_ls00),
																							_tcslen(pDBPartExtrCmd->dbpePartSpec_ls00.psFullTabName_ls00));

					if ( pDBPartExtrCmd->dbpeRestore_ls00 != resUnknown_els00 )
					     datatransformation += " FOR LOAD TABLE ";
				 }
				 //*
				 //* Record
				 //*
				 if ( NULL != pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00 )
				 {
					if ( NULL != pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsFileName_ls00 )
					{
						datatransformation += " CONFIGURATION INSTREAM ";
						datatransformation += pszDeviceTypeName_ls00[pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsDeviceType_ls00];

						configuration.ConvertFromASCII_Latin1( pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsFileName_ls00,
																pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsFileName_ls00 +
														_tcslen(pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsFileName_ls00));
						datatransformation += "'";
						datatransformation += configuration;
						datatransformation += "'";
						datatransformation += pszCodeTypeName_ls00[pDBPartExtrCmd->dbpeConfigurationFile_ls00.fsFormat_ls00.ffoCodeType_ls00];
					}

					datastream.ConvertFromASCII_Latin1( pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00,
														pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00 +
												_tcslen(pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00));

					datatransformation += " DATA OUTSTREAM ";
					datatransformation += pszDeviceTypeName_ls00[pDBPartExtrCmd->dbpeDatfile_ls00.fsDeviceType_ls00];
					datatransformation += "'";
					datatransformation += datastream;
					datatransformation += "'";

					if ( pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoPage_ls00      == true  )
					{
						datatransformation += " PAGES ";
						pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoCompress_ls00   = false;
					}
					if ( pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoCompress_ls00  == true  )
						 datatransformation += " COMPRESSED ";
					if ( pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoFormatted_ls00 == true  )
						 datatransformation += " FORMATTED  ";
					if ( pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoCompact_ls00   == true  )
						 datatransformation += " RECORDS ";

					datatransformation += pszCodeTypeName_ls00[pDBPartExtrCmd->dbpeDatfile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }
				 //*
				 //* Transformation
				 //*
				 if ( NULL != pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00 )
				 {
					  datatransformation += " PACKAGE OUTSTREAM ";
					  datatransformation += pszDeviceTypeName_ls00[pDBPartExtrCmd->dbpePackagefile_ls00.fsDeviceType_ls00];

					  package.ConvertFromASCII_Latin1( pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00,
													   pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00 +
											   _tcslen(pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00));

					  datatransformation += "'";
					  datatransformation += package;
					  datatransformation += "'";
					  datatransformation += pszCodeTypeName_ls00[pDBPartExtrCmd->dbpePackagefile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 if ( pDBPartExtrCmd->dbpeRestart_ls00.rstRestart_ls00 == true )
				 {
					  datatransformation += " RESTART ";
					  datatransformation += "'";
					  datatransformation += pDBPartExtrCmd->dbpeRestart_ls00.rstPackageid_ls00;
					  datatransformation += "'";
				 }

				 if (   NULL != pDBPartExtrCmd->dbpeCatfile_ls00.fsFileName_ls00 &&
					  ( NULL != pDBPartExtrCmd->dbpeDatfile_ls00.fsFileName_ls00 ||
					    NULL != pDBPartExtrCmd->dbpePackagefile_ls00.fsFileName_ls00 ) )
   		                datatransformation += " INTERNAL ";
				 break;
		    }// case srFctDBPartExtr_els00

            case srFctDBPartLoad_els00:
            {
				 tls00_DBPartLoadCmd* pDBPartLoadCmd = REINTERPRET_CAST (tls00_DBPartLoadCmd*, pTransformationCmd->cmdScnDat_ls00);
				 //*
				 //* Authorization
				 //*
				 if ( pDBPartLoadCmd->dbplPartSpec_ls00.psPartType_ls00 == ptAll_els00 )
				 {
					rc = ls15CheckUserMode(pDBInfo,pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(), dbuSysdba_els00, ErrText);
					if (errOK_els00 != rc)
					{
						if (dbRowNotFound_els00 == rc)
						{
							pMsgInstance->ls98Msg(layDBExtract_els98, ErrText, errRestrictedStmt_els98);
						}
						return rc;
					}
				 }
				 metadatatransformation  = "LOAD CATALOG ";
				 metadatatransformation += pszPartTypeName_ls00[pDBPartLoadCmd->dbplPartSpec_ls00.psPartType_ls00];
				 metadatatransformation += " ";

				 if ( pDBPartLoadCmd->dbplPartSpec_ls00.psPartType_ls00 == ptTable_els00 )
					  metadatatransformation += tablename.AssignRaw(REINTERPRET_CAST(unsigned char*, pDBPartLoadCmd->dbplPartSpec_ls00.psFullTabName_ls00),
					                                                                         _tcslen(pDBPartLoadCmd->dbplPartSpec_ls00.psFullTabName_ls00));

				 metadatastream.ConvertFromASCII_Latin1( pDBPartLoadCmd->dbplCatfile_ls00.fsFileName_ls00,
													     pDBPartLoadCmd->dbplCatfile_ls00.fsFileName_ls00 +
											     _tcslen(pDBPartLoadCmd->dbplCatfile_ls00.fsFileName_ls00));

				 metadatatransformation += " INSTREAM ";
				 metadatatransformation += pszDeviceTypeName_ls00[pDBPartLoadCmd->dbplCatfile_ls00.fsDeviceType_ls00];
	            
				 if ( pDBPartLoadCmd->dbplCatfile_ls00.fsDeviceType_ls00 == dtypeTape_ls00 )
				 {
					 metadatatransformation += " EBID ";
					 metadatastreamebid.ConvertFromASCII_Latin1(pDBPartLoadCmd->dbplCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00,
						                                        pDBPartLoadCmd->dbplCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00+
						                                _tcslen(pDBPartLoadCmd->dbplCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00));
					 metadatatransformation += "'";
					 metadatatransformation += metadatastreamebid;
					 metadatatransformation += "'";
				 }

				 metadatatransformation += "'";
				 metadatatransformation += metadatastream;
				 metadatatransformation += "'";

				 if ( pDBPartLoadCmd->dbplCatfile_ls00.fsFormat_ls00.ffoDdl_ls00 == true )
					  metadatatransformation += " DDL ";
				 if ( pDBPartLoadCmd->dbplCatfile_ls00.fsFormat_ls00.ffoXml_ls00 == true )
					  metadatatransformation += " XML ";
				 if ( pDBPartLoadCmd->dbplRestart_ls00.rstRestart_ls00 == true  )
				 {
					  metadatatransformation += " RESTART ";
					  metadatatransformation += "'";
					  metadatatransformation += pDBPartLoadCmd->dbplRestart_ls00.rstPackageid_ls00;
					  metadatatransformation += "'";
				 }

				 metadatatransformation += " INTERNAL ";

				 datatransformation  = "LOAD TABLE ";
  		         datatransformation += pszPartTypeName_ls00[pDBPartLoadCmd->dbplPartSpec_ls00.psPartType_ls00];
				 datatransformation += " ";

				 if ( pDBPartLoadCmd->dbplPartSpec_ls00.psPartType_ls00 == ptTable_els00 )
					  datatransformation += tablename.AssignRaw(REINTERPRET_CAST(unsigned char*, pDBPartLoadCmd->dbplPartSpec_ls00.psFullTabName_ls00),
					                                                                     _tcslen(pDBPartLoadCmd->dbplPartSpec_ls00.psFullTabName_ls00));

				 if ( NULL != pDBPartLoadCmd->dbplConfigurationFile_ls00.fsFileName_ls00 )
				 {
					 datatransformation += " CONFIGURATION INSTREAM ";
					 datatransformation += pszDeviceTypeName_ls00[pDBPartLoadCmd->dbplConfigurationFile_ls00.fsDeviceType_ls00];

					 configuration.ConvertFromASCII_Latin1( pDBPartLoadCmd->dbplConfigurationFile_ls00.fsFileName_ls00,
													        pDBPartLoadCmd->dbplConfigurationFile_ls00.fsFileName_ls00 +
											        _tcslen(pDBPartLoadCmd->dbplConfigurationFile_ls00.fsFileName_ls00));

					 datatransformation += "'";
					 datatransformation += configuration;
					 datatransformation += "'";
					 datatransformation += pszCodeTypeName_ls00[pDBPartLoadCmd->dbplConfigurationFile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 datastream.ConvertFromASCII_Latin1( pDBPartLoadCmd->dbplDatfile_ls00.fsFileName_ls00,
												     pDBPartLoadCmd->dbplDatfile_ls00.fsFileName_ls00 +
										     _tcslen(pDBPartLoadCmd->dbplDatfile_ls00.fsFileName_ls00));

				 datatransformation += " DATA INSTREAM ";
				 datatransformation += pszDeviceTypeName_ls00[pDBPartLoadCmd->dbplDatfile_ls00.fsDeviceType_ls00];
				 
				 if ( pDBPartLoadCmd->dbplDatfile_ls00.fsDeviceType_ls00 == dtypeTape_ls00 )
				 {
					 datatransformation += " EBID ";
					 datastreamebid.ConvertFromASCII_Latin1(pDBPartLoadCmd->dbplDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00,
						                                    pDBPartLoadCmd->dbplDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00+
						                            _tcslen(pDBPartLoadCmd->dbplDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00));
					 datatransformation += "'";
					 datatransformation += datastreamebid;
					 datatransformation += "'";
				 }

				 datatransformation += "'";
				 datatransformation += datastream;
				 datatransformation += "'";

				 if ( pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoPage_ls00      == true )
				 {
					  datatransformation += " PAGES ";
					  pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoCompress_ls00   = false;
				 }
				 if ( pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoCompress_ls00  == true )
					  datatransformation += " COMPRESSED ";
				 if ( pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoFormatted_ls00 == true )
					  datatransformation += " FORMATTED ";
				 if ( pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoCompact_ls00   == true )
					  datatransformation += " RECORDS ";
				
				 datatransformation += pszCodeTypeName_ls00[pDBPartLoadCmd->dbplDatfile_ls00.fsFormat_ls00.ffoCodeType_ls00];

				 if ( NULL != pDBPartLoadCmd->dbplPackagefile_ls00.fsFileName_ls00 )
				 {
					  datatransformation += " PACKAGE OUTSTREAM ";
					  datatransformation += pszDeviceTypeName_ls00[pDBPartLoadCmd->dbplPackagefile_ls00.fsDeviceType_ls00];

					  package.ConvertFromASCII_Latin1( pDBPartLoadCmd->dbplPackagefile_ls00.fsFileName_ls00,
													   pDBPartLoadCmd->dbplPackagefile_ls00.fsFileName_ls00 +
											   _tcslen(pDBPartLoadCmd->dbplPackagefile_ls00.fsFileName_ls00));

					  datatransformation += "  ";
					  datatransformation += "'";
					  datatransformation += package;
					  datatransformation += "'";
					  datatransformation += pszCodeTypeName_ls00[pDBPartLoadCmd->dbplPackagefile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 if ( pDBPartLoadCmd->dbplRestart_ls00.rstRestart_ls00 == true )
				 {
					  datatransformation += " RESTART ";
					  datatransformation += "'";
					  datatransformation += pDBPartLoadCmd->dbplRestart_ls00.rstPackageid_ls00;
					  datatransformation += "'";
				 }

				 datatransformation += " INTERNAL ";

				 break;
			}// case srFctDBPartLoad_els00
	  }

	  //*
      //*   check syntax
	  //*
	  if ( errOK_els00 <= ls11ParseLoadCommand (metadatatransformation, pDBInfo ) &&
	       errOK_els00 <= ls11ParseLoadCommand (datatransformation    , pDBInfo )     )
	  {
		    switch(pTransformationCmd->cmdScanRC_ls00)
			{
		  		  case srFctDBPartExtr_els00:
				  {
					   tls00_DBPartExtrCmd* pDBPartExtrCmd = REINTERPRET_CAST (tls00_DBPartExtrCmd*, pTransformationCmd->cmdScnDat_ls00);

					   if ( pDBPartExtrCmd->dbpeRestart_ls00.rstRestart_ls00 == false && metadatatransformation.Empty() == SAPDB_FALSE )
					        rc = ls11ParseDispatchLoadCommand (metadatatransformation, pDBInfo, ErrText);
					   break;
				  }
				  case srFctDBPartLoad_els00:
				  {
					   tls00_DBPartLoadCmd* pDBPartLoadCmd = REINTERPRET_CAST (tls00_DBPartLoadCmd*, pTransformationCmd->cmdScnDat_ls00);

				       if ( pDBPartLoadCmd->dbplRestart_ls00.rstRestart_ls00 == false && metadatatransformation.Empty() == SAPDB_FALSE )
						    rc = ls11ParseDispatchLoadCommand (metadatatransformation, pDBInfo, ErrText);
					   break;
				  }
			}

			if ( errOK_els00 <= rc && datatransformation.Empty() == SAPDB_FALSE )
				 rc = ls11ParseDispatchLoadCommand (datatransformation, pDBInfo, ErrText);
	  }

	  return rc;
}
/* -----------------------------------------------------------------------------
   ls32ExecDatabaseTransformation
/-------------------------------------------------------------------------------*/
SAPDB_Int4 ls32ExecDatabaseTransformation( tls00_Command    *pTransformationCmd,
								           tls00_DBInfo     *pDBInfo,
								           tsp00_Addr        ErrText)
{
	  ROUTINE_DBG_MEO00 ("ls32ExecDatabaseTransformation");

	  RepServMessages  *pMsgInstance  = RepServMessages::Instance();

	  SAPDB_Int4  rc = errOK_els00;

	  //*
      //*   check if user is sysdba
	  //*
      rc = ls15CheckUserMode(pDBInfo,
                             pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(),
                             dbuSysdba_els00,
                             ErrText);
      if (errOK_els00 != rc)
      {
          if (dbRowNotFound_els00 == rc)
		  {
			  pMsgInstance->ls98Msg(layDBExtract_els98, ErrText, errRestrictedStmt_els98);
		  }
		  return rc;
	  }

	  Tools_DynamicUTF8String  datatransformation;
	  Tools_DynamicUTF8String  datastream;
	  Tools_DynamicUTF8String  datastreamebid;
	  Tools_DynamicUTF8String  metadatatransformation;
	  Tools_DynamicUTF8String  metadatastream;
	  Tools_DynamicUTF8String  metadatastreamebid;
	  Tools_DynamicUTF8String  configuration;
	  Tools_DynamicUTF8String  package;

	  switch(pTransformationCmd->cmdScanRC_ls00)
      {
		    // interpret <databaseextract statement>::=
	        // extract db OUTFILE <external_file_spec> <external_file_spec>
		    case srFctDBExtr_els00:
            {
				 tls00_DBExtrCmd* pDBExtrCmd = REINTERPRET_CAST (tls00_DBExtrCmd*, pTransformationCmd->cmdScnDat_ls00);

				 metadatatransformation  = "EXTRACT CATALOG ALL ";

				 metadatastream.ConvertFromASCII_Latin1( pDBExtrCmd->dbeCatfile_ls00.fsFileName_ls00,
													     pDBExtrCmd->dbeCatfile_ls00.fsFileName_ls00 +
											     _tcslen(pDBExtrCmd->dbeCatfile_ls00.fsFileName_ls00));

				 metadatatransformation += " OUTSTREAM ";
				 metadatatransformation += pszDeviceTypeName_ls00[pDBExtrCmd->dbeCatfile_ls00.fsDeviceType_ls00];
				 metadatatransformation += "'";
				 metadatatransformation += metadatastream;
				 metadatatransformation += "'";

				 if ( pDBExtrCmd->dbeCatfile_ls00.fsFormat_ls00.ffoDdl_ls00 == true )
					  metadatatransformation += " DDL ";
				 if ( pDBExtrCmd->dbeCatfile_ls00.fsFormat_ls00.ffoXml_ls00 == true )
					  metadatatransformation += " XML ";
				 if ( pDBExtrCmd->dbeRestart_ls00.rstRestart_ls00 == true  )
				 {
					  metadatatransformation += " RESTART ";
					  metadatatransformation += "'";
					  metadatatransformation += pDBExtrCmd->dbeRestart_ls00.rstPackageid_ls00;
					  metadatatransformation += "'";
				 }

				 metadatatransformation += " INTERNAL ";

				 datatransformation  = "EXTRACT TABLE ALL ";

				 if ( NULL != pDBExtrCmd->dbeConfigurationFile_ls00.fsFileName_ls00 )
				 {
					  datatransformation += " CONFIGURATION INSTREAM ";
					  datatransformation += pszDeviceTypeName_ls00[pDBExtrCmd->dbeConfigurationFile_ls00.fsDeviceType_ls00];

					  configuration.ConvertFromASCII_Latin1( pDBExtrCmd->dbeConfigurationFile_ls00.fsFileName_ls00,
														     pDBExtrCmd->dbeConfigurationFile_ls00.fsFileName_ls00 +
												     _tcslen(pDBExtrCmd->dbeConfigurationFile_ls00.fsFileName_ls00));
					  datatransformation += "'";
					  datatransformation += configuration;
					  datatransformation += "'";
					  datatransformation += pszCodeTypeName_ls00[pDBExtrCmd->dbeConfigurationFile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 datastream.ConvertFromASCII_Latin1( pDBExtrCmd->dbeDatfile_ls00.fsFileName_ls00,
												     pDBExtrCmd->dbeDatfile_ls00.fsFileName_ls00 +
										     _tcslen(pDBExtrCmd->dbeDatfile_ls00.fsFileName_ls00));

				 datatransformation += " DATA OUTSTREAM ";
				 datatransformation += pszDeviceTypeName_ls00[pDBExtrCmd->dbeDatfile_ls00.fsDeviceType_ls00];
				 datatransformation += "'";
				 datatransformation += datastream;
				 datatransformation += "'";

				 if ( pDBExtrCmd->dbeDatfile_ls00.fsFormat_ls00.ffoCompact_ls00 == true  )
					  datatransformation += " RECORDS ";
				 if ( pDBExtrCmd->dbeDatfile_ls00.fsFormat_ls00.ffoPage_ls00    == true  )
					  datatransformation += " PAGES ";

				 datatransformation += pszCodeTypeName_ls00[pDBExtrCmd->dbeDatfile_ls00.fsFormat_ls00.ffoCodeType_ls00];

				 if ( NULL != pDBExtrCmd->dbePackagefile_ls00.fsFileName_ls00 )
				 {
					  datatransformation += " PACKAGE OUTSTREAM ";
					  datatransformation += pszDeviceTypeName_ls00[pDBExtrCmd->dbePackagefile_ls00.fsDeviceType_ls00];

					  package.ConvertFromASCII_Latin1( pDBExtrCmd->dbePackagefile_ls00.fsFileName_ls00,
													   pDBExtrCmd->dbePackagefile_ls00.fsFileName_ls00 +
											   _tcslen(pDBExtrCmd->dbePackagefile_ls00.fsFileName_ls00));

					  datatransformation += "'";
					  datatransformation += package;
					  datatransformation += "'";
					  datatransformation += pszCodeTypeName_ls00[pDBExtrCmd->dbePackagefile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 if ( pDBExtrCmd->dbeRestart_ls00.rstRestart_ls00 == true )
				 {
					  datatransformation += " RESTART ";
					  datatransformation += "'";
					  datatransformation += pDBExtrCmd->dbeRestart_ls00.rstPackageid_ls00;
					  datatransformation += "'";
				 }

				 datatransformation += " INTERNAL ";

                 break;

            }// case srFctDBExtr_els00

			// interpret <databaseload statement>::=
	        // load db INFILE <external_infile_spec> <external_infile_spec> OUTFILE <external_file_spec_opt> <restart_opt>
            case srFctDBLoad_els00:
            {
				 tls00_DBLoadCmd* pDBLoadCmd = REINTERPRET_CAST (tls00_DBLoadCmd*, pTransformationCmd->cmdScnDat_ls00);

				 metadatatransformation  = "LOAD CATALOG ALL ";

				 metadatastream.ConvertFromASCII_Latin1( pDBLoadCmd->dblCatfile_ls00.fsFileName_ls00,
													     pDBLoadCmd->dblCatfile_ls00.fsFileName_ls00 +
											     _tcslen(pDBLoadCmd->dblCatfile_ls00.fsFileName_ls00));

				 metadatatransformation += " INSTREAM ";
				 metadatatransformation += pszDeviceTypeName_ls00[pDBLoadCmd->dblCatfile_ls00.fsDeviceType_ls00];
	            
				 if ( pDBLoadCmd->dblCatfile_ls00.fsDeviceType_ls00 == dtypeTape_ls00 )
				 {
					 metadatatransformation += " EBID ";
					 metadatastreamebid.ConvertFromASCII_Latin1(pDBLoadCmd->dblCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00,
						                                        pDBLoadCmd->dblCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00+
						                                _tcslen(pDBLoadCmd->dblCatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00));
					 metadatatransformation += "'";
					 metadatatransformation += metadatastreamebid;
					 metadatatransformation += "'";
				 }

				 metadatatransformation += "'";
				 metadatatransformation += metadatastream;
				 metadatatransformation += "'";

				 if ( pDBLoadCmd->dblCatfile_ls00.fsFormat_ls00.ffoDdl_ls00 == true )
					  metadatatransformation += " DDL ";
				 if ( pDBLoadCmd->dblCatfile_ls00.fsFormat_ls00.ffoXml_ls00 == true )
					  metadatatransformation += " XML ";
				 if ( pDBLoadCmd->dblRestart_ls00.rstRestart_ls00 == true  )
				 {
					  metadatatransformation += " RESTART ";
					  metadatatransformation += "'";
					  metadatatransformation += pDBLoadCmd->dblRestart_ls00.rstPackageid_ls00;
					  metadatatransformation += "'";
				 }

				 metadatatransformation += " INTERNAL ";

				 datatransformation = "LOAD TABLE ALL ";

				 if ( NULL != pDBLoadCmd->dblConfigurationFile_ls00.fsFileName_ls00 )
				 {
					 datatransformation += " CONFIGURATION INSTREAM ";
					 datatransformation += pszDeviceTypeName_ls00[pDBLoadCmd->dblConfigurationFile_ls00.fsDeviceType_ls00];

					 configuration.ConvertFromASCII_Latin1( pDBLoadCmd->dblConfigurationFile_ls00.fsFileName_ls00,
													        pDBLoadCmd->dblConfigurationFile_ls00.fsFileName_ls00 +
											        _tcslen(pDBLoadCmd->dblConfigurationFile_ls00.fsFileName_ls00));

					 datatransformation += "'";
					 datatransformation += configuration;
					 datatransformation += "'";
					 datatransformation += pszCodeTypeName_ls00[pDBLoadCmd->dblConfigurationFile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 datastream.ConvertFromASCII_Latin1( pDBLoadCmd->dblDatfile_ls00.fsFileName_ls00,
												     pDBLoadCmd->dblDatfile_ls00.fsFileName_ls00 +
										     _tcslen(pDBLoadCmd->dblDatfile_ls00.fsFileName_ls00));

				 datatransformation += " DATA INSTREAM ";
				 datatransformation += pszDeviceTypeName_ls00[pDBLoadCmd->dblDatfile_ls00.fsDeviceType_ls00];
				 
				 if ( pDBLoadCmd->dblDatfile_ls00.fsDeviceType_ls00 == dtypeTape_ls00 )
				 {
					 datatransformation += " EBID ";
					 datastreamebid.ConvertFromASCII_Latin1(pDBLoadCmd->dblDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00,
						                                    pDBLoadCmd->dblDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00+
						                            _tcslen(pDBLoadCmd->dblDatfile_ls00.fsBackupId_ls00.bBackupIdName_ls00));
					 datatransformation += "'";
					 datatransformation += datastreamebid;
					 datatransformation += "'";
				 }

				 datatransformation += "'";
				 datatransformation += datastream;
				 datatransformation += "'";
				 
				 if ( pDBLoadCmd->dblDatfile_ls00.fsFormat_ls00.ffoCompact_ls00 == true )
					  datatransformation += " RECORDS ";
				 if ( pDBLoadCmd->dblDatfile_ls00.fsFormat_ls00.ffoPage_ls00    == true )
					  datatransformation += " PAGES ";

				 datatransformation += pszCodeTypeName_ls00[pDBLoadCmd->dblDatfile_ls00.fsFormat_ls00.ffoCodeType_ls00];

				 if ( NULL != pDBLoadCmd->dblPackagefile_ls00.fsFileName_ls00 )
				 {
					  datatransformation += " PACKAGE OUTSTREAM ";
					  datatransformation += pszDeviceTypeName_ls00[pDBLoadCmd->dblPackagefile_ls00.fsDeviceType_ls00];

					  package.ConvertFromASCII_Latin1( pDBLoadCmd->dblPackagefile_ls00.fsFileName_ls00,
													   pDBLoadCmd->dblPackagefile_ls00.fsFileName_ls00 +
											   _tcslen(pDBLoadCmd->dblPackagefile_ls00.fsFileName_ls00));

					  datatransformation += "  ";
					  datatransformation += "'";
					  datatransformation += package;
					  datatransformation += "'";
					  datatransformation += pszCodeTypeName_ls00[pDBLoadCmd->dblPackagefile_ls00.fsFormat_ls00.ffoCodeType_ls00];
				 }

				 if ( pDBLoadCmd->dblRestart_ls00.rstRestart_ls00 == true )
				 {
					  datatransformation += " RESTART ";
					  datatransformation += "'";
					  datatransformation += pDBLoadCmd->dblRestart_ls00.rstPackageid_ls00;
					  datatransformation += "'";
				 }

				 datatransformation += " INTERNAL ";

                 break;

            }//case srFctDBLoad_els00

	  }// switch(pTransformationCmd->cmdScanRC_ls00)

	  //*
      //*   check syntax
	  //*
	  if ( errOK_els00 <= ls11ParseLoadCommand (metadatatransformation, pDBInfo ) &&
	       errOK_els00 <= ls11ParseLoadCommand (datatransformation    , pDBInfo )     )
	  {
		    switch(pTransformationCmd->cmdScanRC_ls00)
			{
		  		  case srFctDBExtr_els00:
				  {
					   tls00_DBExtrCmd* pDBExtrCmd = REINTERPRET_CAST (tls00_DBExtrCmd*, pTransformationCmd->cmdScnDat_ls00);

					   if ( pDBExtrCmd->dbeRestart_ls00.rstRestart_ls00 == false )
					        rc = ls11ParseDispatchLoadCommand (metadatatransformation, pDBInfo, ErrText);
					   break;
				  }
				  case srFctDBLoad_els00:
				  {
					   tls00_DBLoadCmd* pDBLoadCmd = REINTERPRET_CAST (tls00_DBLoadCmd*, pTransformationCmd->cmdScnDat_ls00);

				       if ( pDBLoadCmd->dblRestart_ls00.rstRestart_ls00 == false )
						    rc = ls11ParseDispatchLoadCommand (metadatatransformation, pDBInfo, ErrText);
					   break;
				  }
			}

			if ( errOK_els00 <= rc )
				 rc = ls11ParseDispatchLoadCommand (datatransformation, pDBInfo, ErrText);
	  }
	  return rc;

}
/*===========================================================================*
 *     END
 *===========================================================================*/
