/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util;

/**
 *
 */
public class MemIndirection
    extends com.sap.dbtech.util.StructuredMem
{
    protected StructuredMem mem;
    /**
     *
     * @param rawMem com.sap.dbtech.util.StructuredMem
     */
    public MemIndirection(StructuredMem rawMem) {
        this.mem = rawMem;
    }
    /**
     *
     * @return com.sap.dbtech.util.StructuredMem
     */
    public StructuredMem getBase () {
        return this.mem;
    }
    /**
     * getBytes method comment.
     */
    public byte[] getBytes(int offset, int len) {
        return this.mem.getBytes (offset, len);
    }
    /**
     * getInt1 method comment.
     */
    public byte getInt1(int offset) {
        return this.mem.getInt1 (offset);
    }
    /**
     * getUInt1 method comment.
     */
    public int getUInt1(int offset) {
        return this.mem.getUInt1 (offset);
    }
    /**
     * getInt2 method comment.
     */
    public int getInt2(int offset) {
        return this.mem.getInt2(offset);
    }
    /**
     * getInt4 method comment.
     */
    public int getInt4(int offset) {
        return this.mem.getInt4 (offset);
    }
    
	public long getInt8(int offset) {
		  return this.mem.getInt8 (offset);
	}
    
    /**
     * getPointer method comment.
     */
    public StructuredMem getPointer(int offset) {
        return this.mem.getPointer (offset);
    }
    /**
     * getString method comment.
     */
    public String getString(int offset, int len) {
        return this.mem.getString (offset, len);
    }
    /**
     * getStrippedBytes method comment.
     */
    public byte[] getStrippedBytes(int offset, int len) {
        return this.mem.getStrippedBytes (offset, len);
    }
    /**
     * getStrippedString method comment.
     */
    public String getStrippedString(int offset, int len) {
        return this.mem.getStrippedString (offset, len);
    }
    /**
     * reads a bigendian unicode character from <i>offset</i>
     *
     * @param offset
     *
     * @return char
     */
    public char getBigUnicodeChar (int offset) {
        return this.mem.getBigUnicodeChar (offset);
    }
    /**
     * converts <i>lenInBytes</i> bytes
     * into <i>lenInBytes</i> chars.
     *
     * @param offset
     *
     * @param lenInBytes
     *
     * @return char []
     */
    public char [] getBigUnicode (int offset, int lenInBytes) {
        return this.mem.getBigUnicode (offset, lenInBytes);
    }
    /**
     *
     * @param offset int
     */
    public void moveBase (int offset) {
        this.mem.moveBase (offset);
    }
    /**
     * putBytes method comment.
     */
    public void putBytes(byte[] value, int offset) {
        this.mem.putBytes(value, offset);
    }
    /**
     * putBytes method comment.
     */
    public void putBytes(byte[] value, int offset, int len) {
        this.mem.putBytes (value, offset, len);
    }
    /**
     * putStringBytes method comment.
     */
    public void putStringBytes(byte[] value, int offset, int len) {
        this.mem.putStringBytes (value, offset, len);
    }
    /**
     * putUnicodeBytes method comment.
     */
    public void putUnicodeBytes(byte[] value, int offset, int len) {
        this.mem.putUnicodeBytes (value, offset, len);
    }
    /**
     * putBigUnicode method comment.
     */
    public void putBigUnicode(char[] value, int offsetInBytes, int lenInBytes) {
        this.mem.putBigUnicode (value, offsetInBytes, lenInBytes);
    }
    /**
     * putInt1 method comment.
     */
    public void putInt1(int value, int offset) {
        this.mem.putInt1 (value, offset);
    }
    /**
     * putInt2 method comment.
     */
    public void putInt2(int value, int offset) {
        this.mem.putInt2 (value, offset);
    }
    /**
     * putInt4 method comment.
     */
    public void putInt4(int value, int offset) {
        this.mem.putInt4 (value, offset);
    }
    
	public void putInt8(long value, int offset) {
		this.mem.putInt8(value, offset);
	}

    /**
     * putString method comment.
     */
    public int putString(String value, int offset) {
        return this.mem.putString (value, offset);
    }
    /**
     * putString method comment.
     */
    public int putString(String value, int offset, int len) {
        return this.mem.putString (value, offset, len);
    }
    /**
     * size method comment.
     */
    public int size() {
        return this.mem.size ();
    }
    /**
     * dump method comment.
     */
    public void traceOn (java.io.PrintStream outstream) {
        this.mem.traceOn (outstream);
    }
    /**
     * dump method comment.
     */
    public void traceOn (java.io.PrintStream outstream, int maxBuf) {
        this.mem.traceOn (outstream, maxBuf);
    }
    /**
     * dump method comment.
     */
    public void traceOn (java.io.PrintStream outstream, int from, int to) {
        this.mem.traceOn (outstream, from, to);
    }
}
