/*
    ========== licence begin  GPL
    Copyright (c) 2004-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

 */
#ifndef DATA_MESSAGES_HPP
#define DATA_MESSAGES_HPP

// Generated Header file Data_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define DATA_NOT_IMPLEMENTED                 SAPDBErr_MessageList::Error,0,"%s not yet implemented",1
#define DATA_NOT_IMPLEMENTED_ID 0
#define DATA_PAM_ERROR                       SAPDBErr_MessageList::Error,1,"%s: PageId=%s/%s",3
#define DATA_PAM_ERROR_ID 1
#define DATA_CHAIN_IS_INCONSISTENT           SAPDBErr_MessageList::Error,2,"Chain is inconsistent: '%s'->'%s'",2
#define DATA_CHAIN_IS_INCONSISTENT_ID 2
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED SAPDBErr_MessageList::Error,3,"Truncated record: %s,%s",2
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED_ID 3
#define DATA_ERR_CHECKSUM_MISMATCH           SAPDBErr_MessageList::Error,4,"Checksum mismatch; calculated: %s found: %s",2
#define DATA_ERR_CHECKSUM_MISMATCH_ID 4
#define DATA_ERR_WRITE_COUNT_MISMATCH        SAPDBErr_MessageList::Error,5,"Write count mismatch; header: %s, trailer: %s",2
#define DATA_ERR_WRITE_COUNT_MISMATCH_ID 5
#define DATA_ERR_BAD_PAGE_TYPE               SAPDBErr_MessageList::Error,6,"Bad data page type '%s'",1
#define DATA_ERR_BAD_PAGE_TYPE_ID 6
#define DATA_ERR_CORRUPTED_PAGE              SAPDBErr_MessageList::Error,7,"Corrupted data page %s of filetype '%s' identified by root %s",3
#define DATA_ERR_CORRUPTED_PAGE_ID 7
#define DATA_NOT_ENOUGH_SPACE                SAPDBErr_MessageList::Error,8,"PageAccessManager: cannot allocate new pages",0
#define DATA_NOT_ENOUGH_SPACE_ID 8
#define DATA_ERROR_VERIFY_PAGE               SAPDBErr_MessageList::Error,9,"Verify page %s next: %s, root: %s, chainroot: %s, prev: %s",5
#define DATA_ERROR_VERIFY_PAGE_ID 9
#define DATA_ERROR_MARK_USED                 SAPDBErr_MessageList::Error,10,"Verify page %s: error during 'mark as used'",1
#define DATA_ERROR_MARK_USED_ID 10
#define DATA_ERROR_VERIFY_CHAIN              SAPDBErr_MessageList::Error,11,"Verify chain: root %s, error: %s, first page failed: %s",3
#define DATA_ERROR_VERIFY_CHAIN_ID 11
#define DATA_ERR_PRIM_STATISTIC              SAPDBErr_MessageList::Error,12,"Base error '%s' during update statistic on record index %s on page %s of root %s",4
#define DATA_ERR_PRIM_STATISTIC_ID 12
#define DATA_ERR_SCAN_TREE                   SAPDBErr_MessageList::Error,13,"Base error '%s' during tree scan operation on record index %s on page %s of root %s",4
#define DATA_ERR_SCAN_TREE_ID 13
#define DATA_COMPONENT_TEST_FAILED           SAPDBErr_MessageList::Error,14,"Component test failed: %s",1
#define DATA_COMPONENT_TEST_FAILED_ID 14
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH   SAPDBErr_MessageList::Error,15,"fix size is %s but requested is %s",2
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH_ID 15
#define DATA_PAGE_SPLIT_SPACE_VERIFY         SAPDBErr_MessageList::Error,16,"split space page verify failed: pno: %s",1
#define DATA_PAGE_SPLIT_SPACE_VERIFY_ID 16
#define DATA_ERR_INVALID_CHECK_ALGORITHM     SAPDBErr_MessageList::Error,17,"Invalid check algorithm %s.",1
#define DATA_ERR_INVALID_CHECK_ALGORITHM_ID 17
#define DATA_ERR_BAD_PAGE                    SAPDBErr_MessageList::Error,18,"Bad data page %s of filetype '%s' identified by root %s",3
#define DATA_ERR_BAD_PAGE_ID 18
#define DATA_ERR_PAGENO_OUT_OF_RANGE         SAPDBErr_MessageList::Error,19,"Requested %s data page %s of root %s is greater than the upper limit of %s.",4
#define DATA_ERR_PAGENO_OUT_OF_RANGE_ID 19
#define DATA_ERR_REFRENCE_COUNT              SAPDBErr_MessageList::Error,20,"Reference Count mismatch %s, base error '%s' on root %s",3
#define DATA_ERR_REFRENCE_COUNT_ID 20
#define DATA_WRN_BAD_FILE                    SAPDBErr_MessageList::Warning,21,"Bad file for root %s",1
#define DATA_WRN_BAD_FILE_ID 21
#define DATA_PAGE_INFO                       SAPDBErr_MessageList::Info,22,"%s: pno=%s(%s/%s) acc=%s rel=%s err=%s",7
#define DATA_PAGE_INFO_ID 22
#define DATA_PRIM_STATISTIC_CANCELED         SAPDBErr_MessageList::Info,23,"Update statistic on root %s canceled by task %s",2
#define DATA_PRIM_STATISTIC_CANCELED_ID 23
#define DATA_SPLIT_SPACE_RESIZE              SAPDBErr_MessageList::Info,24,"A split space is resized to %s",1
#define DATA_SPLIT_SPACE_RESIZE_ID 24
#define DATA_CHAIN_INFO                      SAPDBErr_MessageList::Info,25,"%s: root %s last %s addressing: %s recovery: %s",5
#define DATA_CHAIN_INFO_ID 25

#endif /* DATA_MESSAGES_HPP */
