
/*!**************************************************************************

    module      : Log_ActionRefreshSurrogSeq.cpp
    -------------------------------------------------------------------------

    author      : JuergenA
    responsible : UweH

    special area: Logging
    description : defines a class to handle log entries for files

    last changed: 2001-04-19

    -------------------------------------------------------------------------

    copyright:    (c) 2000-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

/*===========================================================================*
*  INCLUDES                                                                  *
*============================================================================*/

#include "Logging/Log_ActionRefreshSurrogSeq.hpp"

#include "SAPDBCommon/SAPDB_Types.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/Tracing/SAPDBTrace_Usage.hpp" // Routine trace macros
#include "KernelCommon/Kernel_Trace.hpp"
#include "Logging/Log_ReadWriteActionImage.hpp"

#include "gsp00.h"
#include "ggg00.h"
#include "hkb57.h"

/*===========================================================================*
*  METHODS of Log_ActionRefreshSurrogate                                     *
*============================================================================*/

Log_ActionRefreshSurrogate::Log_ActionRefreshSurrogate (const tgg00_Surrogate &Surrogate,
                                                        const tgg00_Surrogate &SysKey):
Log_ReadWriteActionImage (Log_RefreshSurrogate)
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSurrogate::Log_ActionRefreshSurrogate", LogAction_Trace, 5);
    this->m_Entry.Surrogate = Surrogate;
    this->m_Entry.SysKey    = SysKey;
}

//---------------------------------------------------------------------------

void Log_ActionRefreshSurrogate::Execute (tgg00_TransContext &TransContext) const
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSurrogate::Execute", LogAction_Trace, 5);
    
    KERNEL_TRACE_BASIS_ERROR (TransContext.trError_gg00, LogAction_Trace, 5);
    
    if (e_ok != TransContext.trError_gg00) return; 
    
    kb57RefreshSurrogate (TransContext, this->m_Entry.Surrogate, this->m_Entry.SysKey);
}

//---------------------------------------------------------------------------

void Log_ActionRefreshSurrogate::ReadImagePersistent (Log_ActionImageReader &ImageReader,
                                                      bool                  &IsOk)
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSurrogate::ReadImagePersistent", LogAction_Trace, 5);
    
    KERNEL_TRACE_IS_OK (IsOk, LogAction_Trace, 5);
    
    ImageReader.CopyImage (
        REINTERPRET_CAST (SAPDB_Byte*, &(this->m_Entry)),
        sizeof(this->m_Entry),
        IsOk);
}


/*===========================================================================*
*  METHODS of Log_ActionRefreshSequence                                      *
*============================================================================*/

Log_ActionRefreshSequence::~Log_ActionRefreshSequence ()
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSequence::~Log_ActionRefreshSequence", LogAction_Trace, 5);
    if (NULL != this->m_pSequenceListAllocator)
    {
        this->m_pSequenceListAllocator->Deallocate (this->m_pSequenceListForRead);
        this->m_pSequenceListForRead = NULL;
    }
}

//---------------------------------------------------------------------------

void Log_ActionRefreshSequence::Execute (tgg00_TransContext &TransContext) const
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSequence::Execute", LogAction_Trace, 5);
    
    KERNEL_TRACE_BASIS_ERROR (TransContext.trError_gg00, LogAction_Trace, 5);
    
    if (e_ok != TransContext.trError_gg00) return; 
    
    for (SAPDB_Int Curr = 0; Curr < this->m_SequenceCount; ++Curr)
    {
        kb57RefreshSequence 
            (TransContext, (this->m_pSequenceList+Curr)->Surrogate, (this->m_pSequenceList+Curr)->Number);
        
        if (e_ok != TransContext.trError_gg00) return;
    }
}

//---------------------------------------------------------------------------

void Log_ActionRefreshSequence::ReadImagePersistent (Log_ActionImageReader &ImageReader,
                                                     bool                  &IsOk)
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSequence::ReadImagePersistent", LogAction_Trace, 5);
    
    KERNEL_TRACE_IS_OK (IsOk, LogAction_Trace, 5);
    
    ImageReader.CopyImage (
        REINTERPRET_CAST (SAPDB_Byte*, &(this->m_SequenceCount)),
        sizeof(this->m_SequenceCount),
        IsOk);
    
    if ( ! IsOk ) return;
    
    ImageReader.PersistentRead (REINTERPRET_CAST (SAPDB_Byte*&, this->m_pSequenceListForRead),
        this->m_SequenceCount * sizeof(SequenceItem), this->m_pSequenceListAllocator, IsOk);
    
    if ( ! IsOk ) return;
    
    this->m_pSequenceList = this->m_pSequenceListForRead;
}

//---------------------------------------------------------------------------

void Log_ActionRefreshSequence::WriteImagePersistent (Log_ActionImageWriter &ImageWriter,
                                                      bool                  &IsOk)       const
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionRefreshSequence::WriteImagePersistent", LogAction_Trace, 5);
    
    KERNEL_TRACE_IS_OK (IsOk, LogAction_Trace, 5);
    
    ImageWriter.PersistentWrite (&(this->m_SequenceCount), sizeof (this->m_SequenceCount), IsOk);
    
    if ( ! IsOk ) return;
    
    ImageWriter.PersistentWrite (this->m_pSequenceList, this->m_SequenceCount * sizeof(SequenceItem), IsOk);
}

/*===========================================================================*
*  END OF CODE                                                               *
*============================================================================*/
