/*



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end





*/

#ifndef OMS_NEWOBJCACHE_HPP
#define OMS_NEWOBJCACHE_HPP

#include "gsp00.h"

class OmsObjectContainer;
struct OmsObjectId;
class OMS_Context;

#include "Container/Container_Hash.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_RawAllocator.hpp"

class OMS_NewObjList;
typedef Container_Hash<tsp00_Uint4, OMS_NewObjList*>      OMS_NewObjHash;

class OMS_NewObjCache
{
public:
#ifdef USE_SYSTEM_ALLOC_CO13
  OMS_NewObjCache();
#else
  OMS_NewObjCache(SAPDBMem_RawAllocator &allocator) 
    : m_Allocator(allocator), m_Containers(allocator)
  {
  }
#endif
  ~OMS_NewObjCache();

  void registerObject(tsp00_Uint4 cont, OmsObjectContainer *p, OmsObjectContainer **chainPtr);
  void removeObject(OmsObjectContainer *p, OMS_Context* context);

  const OmsObjectContainer *nextObject(
      tsp00_Uint4               contid, 
      tsp00_Int4                objsize,
      const OmsObjectContainer  *last);

  void SetEmpty();	// clear cache

private:
#ifndef USE_SYSTEM_ALLOC_CO13
  SAPDBMem_RawAllocator   &m_Allocator;
#endif
  OMS_NewObjHash          m_Containers;
};

#endif  // OMS_NEWOBJCACHE_HPP
