/*!
    @ingroup        Restart
    @file           Rst_RedoTaskLifeCycle.hpp
    @author         JuergenA
    @author         UweH
    @brief          defines classes to start and stop redo tasks
*/
/*

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 */
#ifndef RST_REDO_TASK_LIFE_CYCLE_H
#define RST_REDO_TASK_LIFE_CYCLE_H
#include "SAPDBCommon/SAPDB_Types.hpp"
#include "ggg00.h"
/*!
    @class Rst_RedoExecuteTaskLifeCycle
    @brief starting and stopping of redo execute tasks
 */
class Rst_RedoExecuteTaskLifeCycle
{
public:
	/// Starts all redo execute tasks. If an error occurs the basis error of the TransContext is set.
    Rst_RedoExecuteTaskLifeCycle (tgg00_TransContext &TransContext);
	/// Stops all redo execute tasks. If an error occurs the basis error of the TransContext is set.
    ~Rst_RedoExecuteTaskLifeCycle ();
private:
    /// transaction context for starting the RedoRead-Task
    tgg00_TransContext &m_TransContext;
    /// number of running RedoExecute-Tasks
    SAPDB_Int           m_RunningTasks;
};
/*!
    @class Rst_RedoReadTaskLifeCycle
    @brief starting and stopping of the log reader task
 */
class Rst_RedoReadTaskLifeCycle
{
private:
    /// transaction context for starting the RedoRead-Task
    tgg00_TransContext &m_TransContext;
    /// number of running Redo-Tasks (should be 0 or 1)
    SAPDB_Int           m_RunningTasks;
public:
	/// Starts the log reader task. If an error occurs the basis error of the TransContext is set.
    Rst_RedoReadTaskLifeCycle (tgg00_TransContext &TransContext);
	/// Stops the log reader task. If an error occurs the basis error of the TransContext is set.
    ~Rst_RedoReadTaskLifeCycle ();
};
#endif  /* RST_REDO_TASK_LIFE_CYCLE_H */
