/*!---------------------------------------------------------------------
  @file           RTE_SpeedInfo.cpp
  @author         JoergM, RobinW
  @brief          DBM: SAPDB Instance and Database Registration and Management Interfaces
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
---------------------------------------------------------------------*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "RunTime/RTE_SpeedInfo.hpp"
#ifdef _WIN32
#include "gos00.h" /* nocheck */
#endif

RTE_SpeedInfo speedNone  ((const unsigned char *)"none" ,              -1, true,"");
#ifdef _WIN32
RTE_SpeedInfo speedFast  ((const unsigned char *)"fast" ,KERNEL_TYPE_FAST, true,DB_FAST_KERN_FILE_NAME);
RTE_SpeedInfo speedQuick ((const unsigned char *)"quick",KERNEL_TYPE_QUICK,true,DB_QUICK_KERN_FILE_NAME);
RTE_SpeedInfo speedSlow  ((const unsigned char *)"slow" ,KERNEL_TYPE_SLOW, true,DB_SLOW_KERN_FILE_NAME);
RTE_SpeedInfo speedTest  ((const unsigned char *)"test" ,KERNEL_TYPE_TEST, true,DB_TEST_KERN_FILE_NAME);
#else
RTE_SpeedInfo speedFast  ((const unsigned char *)"fast" ,               0, true,"kernel");
RTE_SpeedInfo speedQuick ((const unsigned char *)"quick",               1, true,"quickknl");
RTE_SpeedInfo speedSlow  ((const unsigned char *)"slow" ,               2, true,"slowknl");
RTE_SpeedInfo speedTest  ((const unsigned char *)"test" ,               3, true,"omststknl");
#endif
