/*!========================================================================
  
  @file         RTE_TagFileHandlingUNIX.hpp
  @author       StefanP
  @ingroup      Runtime
  @brief        Functions handling the Tag Files in '/usr/spool/sql/...'
                


  @since        2003-09-29  17:50
  @sa           

  =======================================================================

  \if EMIT_LICENCE
    
    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

  \endif
  ----------------------------------------------------------------------------*/


#ifndef RTE_TAGFILEHANDLINGUNIX_HPP
#define RTE_TAGFILEHANDLINGUNIX_HPP


#if !defined (_WIN32)
/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include    "SAPDBCommon/SAPDB_ToString.hpp"
#include    "RunTime/RTE_MessageList.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/
#define     RTE_IPCDirectory    "/usr/spool/sql/ipc"
#define     RTE_SQLDirectory    "/usr/spool/sql"



/*!
   @brief  Tag file praefixes 
          
*/

#define RTE_CLIENT_PREFIX            "client"
#define RTE_KERNEL_PREFIX            "kernel"



//#define RTE_SemaphoreFilePrefix     "semaphore"
#define RTE_SEMAPHORE_FILE_PREFIX          's'
#define RTE_SHARED_MEMORY_FILE_PREFIX      'm'

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/
typedef enum {UndefUser = 0,
              ClientUser,
              KernelUser
} RTE_UserType;

typedef enum {Undef = 0,
              Semaphore,
              SharedMemory
} RTE_ResourceType;

typedef int     RTE_Handle;
/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/
SAPDB_Bool      RTE_GetTagFileName     (RTE_Path                        path,
                                        RTE_UserType const              userType,
                                        RTE_DBName const                serverDB,
                                        RTE_ResourceType const          resourceType,
                                        RTE_Handle const                handle,
                                        SAPDBErr_MessageList &          messageList);

void            RTE_GetIPCDir          (RTE_Path                        path);

void            RTE_GetSQLDir          (RTE_Path                        path);

SAPDB_Bool      RTE_RemoveTagFile      (RTE_UserType const              userType,
                                        RTE_DBName const                serverDB,
                                        RTE_ResourceType const          resourceType,
                                        RTE_Handle const                handle,
                                        SAPDBErr_MessageList &          messageList);

inline SAPDB_ToStringClass SAPDB_ToString(RTE_ResourceType     type)
{
    switch(type)
    {
    case Undef: 
        return SAPDB_ToStringClass("Undefined");
    case Semaphore: 
        return SAPDB_ToStringClass("Semaphore");
    case SharedMemory: 
        return SAPDB_ToStringClass("SharedMemory");
    default:                          
        break;
    }
    return SAPDB_ToStringClass((SAPDB_Int4)type); 
}

inline SAPDB_ToStringClass SAPDB_ToString(RTE_UserType     type)
{
    switch(type)
    {
    case UndefUser: 
        return SAPDB_ToStringClass("Undefined");
    case ClientUser: 
        return SAPDB_ToStringClass("Client");
    case KernelUser: 
        return SAPDB_ToStringClass("Kernel");
    default:                          
        break;
    }
    return SAPDB_ToStringClass((SAPDB_Int4)type); 
}


#endif  /* UNIX */
#endif  /* RTE_TAGFILEHANDLINGUNIX_HPP */
