/*!
  @file           RTESync_SpinlockPoolRegister.hpp
  @author         RobinW
  @ingroup        Runtime
  @brief          Register for Spinlock Pools


\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/
#ifndef RTESYNC_SPINLOCKPOOLREGISTER_HPP
#define RTESYNC_SPINLOCKPOOLREGISTER_HPP

#include "SAPDB/SAPDBCommon/SAPDB_Types.hpp"
#include "SAPDB/RunTime/RTE_Types.hpp"
#include "SAPDB/RunTime/Synchronisation/RTESync_NamedSpinlock.hpp"

class RTESync_SpinlockPool;
class RTESync_BaseSpinlockPool;

class RTESync_SpinlockPoolRegister : public RTE_ItemRegister<RTESync_BaseSpinlockPool>
{
public:
    static const SAPDB_Int4 m_MaxIdentfierLength;

    struct StatisticInfo
    {
        SAPDB_UTF8  PoolName[40+4];
        SAPDB_Int4  NumberOfSpinlocks;

        RTE_SpinlockStatistic Maximum;
        RTE_SpinlockStatistic Minimum;
        RTE_SpinlockStatistic Average;
    };

    /*!
        Function: Instance

        description: Return reference to single instance of RTESync_SpinlockRegister

        The InitializeInstance function must have been called before.

        Return value: Reference to singleton instance
     */
    static RTESync_SpinlockPoolRegister & Instance( );
    /*!
       Function: GetStatisticInfo
       Description: Get a snapshot of all statistic informations
       Arguments: pInfoArray[out] Pointer to array of StatisticInfo

       Return value: True if info array fill, false if not not enough memory
     */
    SAPDB_Bool GetStatisticInfo(StatisticInfo * &pInfoArray, SAPDB_Int4 &itemCount, RTESync_Spinlock::Mode mode );

    /*!
       Function: FreeStatisticInfo
       Description: Free the snapshot of all statistic informations collected by GetStatisticInfo

       Arguments: pInfoArray[in] Pointer to array of StatisticInfo
     */
    void FreeStatisticInfo(StatisticInfo *pInfoArray);

private:
    RTESync_SpinlockPoolRegister(SAPDB_Bool makeBackupCopy):RTE_ItemRegister<RTESync_BaseSpinlockPool>(makeBackupCopy) {}

    /*!
       Function: FillStatisticInfo
       Description: Fill the statistic informations
       
       Called by GetStatisticInfo, to call at least memory allocation outside of locked registration code

       Arguments: pInfoArray[in] Pointer to array of StatisticInfo
     */
    SAPDB_Bool FillStatisticInfo(StatisticInfo * &pInfoArray, SAPDB_Int4 maxCount, SAPDB_Int4 &itemCount, RTESync_Spinlock::Mode mode );

    static RTESync_SpinlockPoolRegister *m_Instance;
};

class RTESync_SpinlockPoolReader
{

public:

    /* -----------------------------------------------------------------------*/
    /*! chapter: Constructors and initialization                              */
    /* -----------------------------------------------------------------------*/

    RTESync_SpinlockPoolReader (void);
    
    ~RTESync_SpinlockPoolReader (void);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Constructors and initialization                           */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Iteration                                                    */
    /* -----------------------------------------------------------------------*/

    SAPDB_Bool First (RTESync_Spinlock::Mode mode = RTESync_Spinlock::normal);


    SAPDB_Bool Next (void);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Iteration                                                 */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Data Access                                                  */
    /* -----------------------------------------------------------------------*/

    SAPDB_Bool Name (SAPDB_UTF8 name[]);

    SAPDB_Bool NumberOfElements (SAPDB_Int4 &elements);

    SAPDB_Bool MaxLocks (SAPDB_UInt8 &maxLocks);

    SAPDB_Bool MinLocks (SAPDB_UInt8 &minLocks);

    SAPDB_Bool AvgLocks (SAPDB_UInt8 &avgLocks);

    SAPDB_Bool MaxCollisions (SAPDB_UInt8 &maxCollisions);

    SAPDB_Bool MinCollisions (SAPDB_UInt8 &minCollisions);

    SAPDB_Bool AvgCollisions (SAPDB_UInt8 &avgCollisions);

    SAPDB_Bool MaxTotalSpinLoops (SAPDB_UInt8 &maxTotalSpinLoops);

    SAPDB_Bool MinTotalSpinLoops (SAPDB_UInt8 &minTotalSpinLoops);

    SAPDB_Bool AvgTotalSpinLoops (SAPDB_UInt8 &avgTotalSpinLoops);

    SAPDB_Bool MaxTotalYieldLoops (SAPDB_UInt8 &maxTotalYieldLoops);

    SAPDB_Bool MinTotalYieldLoops (SAPDB_UInt8 &minTotalYieldLoops);

    SAPDB_Bool AvgTotalYieldLoops (SAPDB_UInt8 &avgTotalYieldLoops);

    SAPDB_Bool MaxMaxSpinLoops (SAPDB_UInt8 &maxMaxSpinLoops);

    SAPDB_Bool MinMaxSpinLoops (SAPDB_UInt8 &minMaxSpinLoops);

    SAPDB_Bool AvgMaxSpinLoops (SAPDB_UInt8 &avgMaxSpinLoops);

    SAPDB_Bool MaxMaxYieldLoops (SAPDB_UInt8 &maxMaxYieldLoops);

    SAPDB_Bool MinMaxYieldLoops (SAPDB_UInt8 &minMaxYieldLoops);

    SAPDB_Bool AvgMaxYieldLoops (SAPDB_UInt8 &avgMaxYieldLoops);

    SAPDB_Bool MaxCurrentLoops (SAPDB_UInt8 &maxCurrentLoops);

    SAPDB_Bool MinCurrentLoops (SAPDB_UInt8 &minCurrentLoops);

    SAPDB_Bool AvgCurrentLoops (SAPDB_UInt8 &avgCurrentLoops);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Data Access                                               */
    /* -----------------------------------------------------------------------*/


private:

    void FreeArray (void);

    RTESync_SpinlockPoolRegister::StatisticInfo *m_pInfoArray;
    SAPDB_Int4                                   m_Elements;
    SAPDB_Int4                                   m_Current;
    
};
#endif // RTESYNC_SPINLOCKPOOLREGISTER_HPP



