/*!
  @file           Catalog_Instance.hpp
  @author         ThomasA
  @brief          Implements the catalog interface

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/

#ifndef CATALOG_INSTANCE_HPP
#define CATALOG_INSTANCE_HPP

#include "SQLManager/Catalog/Catalog_Interface.hpp"
#include "SAPDBCommon/SAPDB_Singleton.hpp"

class KSQL_Connection;
class SAPDBErr_MessageList;
class RTESync_IRWRegion;
class Catalog_Instance;
/*!
   @brief creates the catalog instance. This is a singleton providing the catalog interface.
*/
class Catalog_Instance : public Catalog_Interface, public SAPDB_SingletonTemplate<Catalog_Instance>
{
public :
#if defined(KERNEL80)
    virtual int  Create();
#endif
    virtual void DDLShareLock(bool releaseLock, RTE_TaskId pid);
    virtual void DDLExclusiveLock(bool releaseLock, RTE_TaskId pid);
private :
    Catalog_Instance();
    void Abort(const SAPDBErr_MessageList& errorList);
#if defined(KERNEL80)
    void createCatalogObject (KSQL_Connection& con, const char* stmt);
    void createCatalogDomains (KSQL_Connection& con);
    void createCatalogTables (KSQL_Connection& con);
#endif
    RTESync_IRWRegion* m_ddlLock;
    friend class SAPDB_SingletonTemplate<Catalog_Instance>;
};

#endif