/*



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end





*/
#ifndef TOOLS_UNICODECASETABLE_HPP
#define TOOLS_UNICODECASETABLE_HPP

// Generated UnicodeCaseTable.cpp.
// Generated by UniCaseGen.pl DO NOT EDIT

// This file was generated using genCaseMaps 1.0
// Inputfile was UnicodeData.txt Version of 18.11.1999
// For latest version of this file see http://www.unicode.org


// This file explictly does ignore 'SpecialCasing.txt' information!!!
//  Candidates for wrong mapping are:
//   'german sharp sz' capitalizes to 2 'capital S'
//   'ligatures' capitalize into two separated characters
//   some 'precomposed characters' have no counterpart
//   all letters with 'iota-subscript' or 'iota-adjust'
//  Things that are not realizable here but must be handled by application are:
//   special case for final forms (Greek capital letter sigma)
//   locale sensitive character mapping (Turkish mapping of Capital Letter I)
// This file finally also does not support TitleCaseMapping

// So using these tables you are limited to those unicode characters, that
// map into a single unicode character...


// Needed for SAPDB_UInt2 only: Defined as an 16bit unsigned data type
#include "SAPDBCommon/SAPDB_Types.hpp"

// two stages of mappings are used...
struct Tools_UCS2Map { SAPDB_UInt2 mapping[256]; };

//----------------------------------------------------
// Reference to generated first stage mapping tables
//----------------------------------------------------
extern Tools_UCS2Map *Tools_UCS2UpperCaseMap[256];
extern Tools_UCS2Map *Tools_UCS2LowerCaseMap[256];

//----------------------------------------------------
// Inline functions for single character mapping
// !!!Ignoring special multicharacter mapping cases!!!
//----------------------------------------------------
inline SAPDB_UInt2 Tools_UCS2ToUpper(SAPDB_UInt2 KeyToMap)
{
  register Tools_UCS2Map *Map = Tools_UCS2UpperCaseMap[KeyToMap>>8];
  return ( Map != 0 ? Map->mapping[KeyToMap%256] : KeyToMap );
}

inline SAPDB_UInt2 Tools_UCS2ToLower(SAPDB_UInt2 KeyToMap)
{
  register Tools_UCS2Map *Map = Tools_UCS2LowerCaseMap[KeyToMap>>8];
  return ( Map != 0 ? Map->mapping[KeyToMap%256] : KeyToMap );
}

#endif /* TOOLS_UNICODECASETABLE_HPP */
