#ifndef WDVHANDLER_TYPES_H
#define WDVHAMDLER_TYPES_H

/****************************************************************************

  module      : WDVHandler_Types.h

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area: 
  description : 


  last changed: 2001-03-01  9:37
  see also    : 

  -------------------------------------------------------------------------


  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end

*****************************************************************************/

	#include "SAPDB/WebDAV/CAPI/WDVCAPI_Definition.h"
	#include <time.h>

	/*------------------------------------------------------------------------
	 |   DEFINES                                                             |
	 -------------------------------------------------------------------------*/
	/* Prefix is variable - it is adjustable via waadmin.wa Parameter URLprefix */	
	/* #define WDVD_WEBDAV_SERVER_PREFIX					"/webdav"*/
	#define WDVD_WEBDAV_SERVER_NAME						"SAP DB WWW WebDAV"

	#define WDVD_PATH_SEPARATOR							'/'
	#define WDVD_PATH_SEPARATOR_STR						"/"
	#define WDVD_NS_SEPARATOR							'&'

	/*---------------------------------------------------------------------------*/

	#define WDVD_MAX_SYSKEY_LEN                          WDV_MAX_SYSKEY_LEN

	#define WDVD_MAX_ERROR_TEXT_LEN                      WDV_MAX_ERROR_TEXT_LEN
	#define WDVD_MAX_STATE_TEXT_LEN                      WDV_MAX_STATE_TEXT_LEN

	#define WDVD_MAX_URI_LEN                             WDV_MAX_URI_LEN

	#define WDVD_MAX_RESOURCE_NAME_LEN                   WDV_MAX_RESOURCE_NAME_LEN

	#define WDVD_MAX_NAME_SPACE_LEN			             WDV_MAX_NAME_SPACE_LEN
	#define WDVD_MAX_NAME_SPACE_PREFIX_LEN			     WDV_MAX_NAME_SPACE_LEN
	#define WDVD_MAX_PROPERTY_NAME_PREFIX_LEN			 WDV_MAX_PROPERTY_NAME_PREFIX_LEN
	#define WDVD_MAX_PROPERTY_SHORT_VALUE_LEN			 WDV_MAX_PROPERTY_SHORT_VALUE_LEN
	#define WDVD_MAX_PROPERTY_LONG_VALUE_LEN			 WDV_MAX_PROPERTY_LONG_VALUE_LEN

	#define WDVD_MAX_IF_HEADER_LEN						 1000

	#define WDVD_MAX_XML_BUFFER_LEN		                 (WDVD_MAX_PROPERTY_LONG_VALUE_LEN / 2) + 1
	#define WDVD_MAX_XML_TAG_LEN						 WDVD_MAX_PROPERTY_NAME_PREFIX_LEN + WDVD_MAX_NAME_SPACE_LEN + 4
	#define WDVD_MAX_STR_BUFFER_LEN		                 20000
	#define WDVD_max_put_buffer_len						 128000
	#define WDVD_max_get_buffer_len						 128000

    #define WDVD_MAX_HTTP_DATE_LEN                       50

	/*------------------------------------------------------------------------
	 |   TYPES                                                               |
	 -------------------------------------------------------------------------*/
	/* Basic types */
	typedef unsigned int		WDVD_UInt4;
	typedef unsigned short		WDVD_UInt2;
	typedef unsigned char		WDVD_UInt1;
	typedef short				WDVD_Int2;
	typedef int			        WDVD_Int4;
	typedef unsigned char		WDVD_Bool;
	typedef size_t				WDVD_Length;
	typedef char		        WDVD_Char;
	typedef char		       *WDVD_PChar;
	typedef double				WDVD_Double;

	/*--------------------------------------------------------------------------
	declaration: sapdbwa_{ULong | Long}
	description: basic long data types for fastest execution
				 (machine-dependent size)
	--------------------------------------------------------------------------*/
	#if defined(WIN32) && defined(_M_IA64)
	typedef unsigned __int64    WDVD_ULong;      /* long (fast, unsigned) */
	typedef signed __int64      WDVD_Long;       /* long (fast, signed)   */
	#else
	typedef unsigned long       WDVD_ULong;      /* long (fast, unsigned) */
	typedef signed long         WDVD_Long;       /* long (fast, signed)   */
	#endif

	#define WDVD_True			((WDVD_Bool)1)
	#define WDVD_False			((WDVD_Bool)0)

	/* WDVDelete */
	typedef char				*WDVD_URI;
	typedef char                WDVD_URIString[WDVD_MAX_URI_LEN+1];
	typedef char                WDVD_ResourceName[WDVD_MAX_RESOURCE_NAME_LEN+1];

	/*------------------------------------------------------------------------
		ERROR         
	--------------------------------------------------------------------------*/
	typedef WDVD_UInt2			WDVD_Error;
	
	#define WDVD_WEBDAV_SERVER_PREFIX_DEFAULT				"/webdav"
	#define WDVD_WEBDAV_SERVER_PREFIX_PARAM					"URLprefix"


	/*------------------------------------------------------------------------
		ERROR HANDLE
	--------------------------------------------------------------------------*/
	struct st_error_handle {
		WDVCAPI_ErrorItem		errorItem;
		WDVCAPI_ErrorType		errorType;
		WDVCAPI_ErrorCode		errorCode;
		WDVCAPI_ErrorText		errorMsg;
		WDVD_Error				error;
		WDVD_Char				errorText[1000];
	};
	typedef struct st_error_handle	*WDVD_ErrorHandle;

	/*------------------------------------------------------------------------
		CONNECTION USER DATA 
	--------------------------------------------------------------------------*/
	struct st_conn_user_data {
		WDVCAPI_WDV		wdvHandle;
	};
	typedef struct st_conn_user_data	*WDVD_ConnUserData;

#endif