/*!**************************************************************************

  module      : hbd90.h

  -------------------------------------------------------------------------

  responsible : AlexanderK

  special area: 
  description : Declaration of exported functions of modul vbd90.cpp


  version     : 7.2.0.0
  last changed: 1999-06-22  15:47
  see also    :

  -------------------------------------------------------------------------

  copyright:    (c) 1998-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

#ifndef HBD90_H
#define HBD90_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg92.h"
#include "gbd00.h"
#include "gbd910.h"

#include "Logging/Log_Types.hpp"
#include "liveCache/LVC_Types.hpp"
#include "liveCache/LVC_AbstractObjKeyIterator.hpp"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

/* new PTS 1135542 */
externCpp void 
bd90TransEnd(tgg00_TransContext   &Trans);

/*---------------------------------------------------------------------------*/

externCpp void
bd90CreateEntryInPersFileDirectory (tbd_current_tree &Current);

/*---------------------------------------------------------------------------*/

externCpp void
bd90CreateObjFile (tbd_current_tree    &Current,
				   tsp00_Int4           ObjBodyLen,
				   tsp00_Int4           ObjKeyLen,
				   tsp00_Int4           NumObjKeyFiles,
				   LVC_RootPageNoArray &RootPageNoArray);

/*---------------------------------------------------------------------------*/

externCpp void
bd90Rollforward_CreateObjFile (tbd_current_tree          &Current,
				               tsp00_Int4                 ObjBodyLen,
				               tsp00_Int4                 ObjKeyLen,
				               tsp00_Int4                 NumObjKeyFiles,
				               const LVC_RootPageNoArray &RootPageNoArray);

/*---------------------------------------------------------------------------*/

externCpp void 
bd90DelAllObj (tbd_current_tree  &Current,           //[inp\out]
			   tsp00_Int4        &NumDelObj,         //[out]
               tgg92_KernelOid   &ErrorOid);
/*---------------------------------------------------------------------------*/

externCpp void 
bd90DelObj (tbd_current_tree       &Current,           //[inp\out]
            tgg92_KernelOid        &OId,               //[inp\out] 
            tgg91_PageRef           WantedObjVers);    //[inp]


/*---------------------------------------------------------------------------*/
// PTS 1119647 FF 2002-DEC-05
externCpp void
bd90DropObjFile (tbd_current_tree   &Current);

/*---------------------------------------------------------------------------*/

externC void
bd90GetNumChains (tsp00_Int4  &NumObjPageChains);
 
/*----------------------------------------------------------------------------*/
// PTS 1120478
externCpp void
bd90GetContainerId (tbd_current_tree  &Current,            //[in\out]
                    tgg92_KernelOid    OId);               //[in]

/*----------------------------------------------------------------------------*/

externCpp void
bd90GetObjConsistent (tbd_current_tree  &Current,            //[inp\out] 
                      tgg92_KernelOid   &OId,                //[inp\out] 
                      tsp00_Int4         ExtObjBodySize,     //[inp= buffersize for object]
                      void              *pExtObjBody,        //[inp]
                      tsp00_Int4         HashKeySize,        //[inp]
                      void              *pHashKey,           //[inp]  
					  tsp00_Int4        &ObjBodySize,        //[out=length of the object] 
                      tsp00_Int4        &KeyLen,             //[out]
                      tsp00_Byte*       *pKey,               //[out]
                      tgg91_PageRef     &ResultObjVers,       //[out]
                      tsp00_Int4        &LogReadAccesses);   //[out] PTS 1107819 AK 12/09/2000

/*---------------------------------------------------------------------------*/

externCpp void
bd90GetObjConsistentWithLock (tbd_current_tree  &Current,            //[inp\out] 
							  tgg92_KernelOid   &OId,                //[inp\out] 
							  tsp00_Int4         ExtObjBodySize,     //[inp= buffersize for object]
							  void              *pExtObjBody,        //[inp]
							  tsp00_Int4         HashKeySize,        //[inp]
							  void              *pHashKey,           //[inp]  
							  tsp00_Int4        &ObjBodySize,        //[out=length of the object] 
							  tsp00_Int4        &KeyLen,             //[out]
							  tsp00_Byte*       *pKey,               //[out]
							  tgg91_PageRef     &ResultObjVers,      //[out]
							  tsp00_Int4        &LogReadAccesses);   //[out] PTS 1107819 AK 12/09/2000

/*----------------------------------------------------------------------------*/

externCpp void
bd90GetObjFileStatistics (tbd_current_tree   &Current,
						  tsp00_Int4         &NumAllPages,
						  tsp00_Int4         &NumFreePages,
						  tsp00_Int4         &NumEmptyPages,
						  tsp00_Int4         &NumKeyLeaves,        /* PTS 1107153 AK 17/07/2000 */
						  tsp00_Int4         &Occupancy)           /* PTS 1107153 AK 17/07/2000 */ ;

/*---------------------------------------------------------------------------*/
/* CRS 1106284 AK 11-03-2000 */

externCpp void
bd90IsObjHistoryUsed (tbd_current_tree &Current,
                     tgg92_KernelOid   &OId,
                     bool              &bHistoryIsUsed);

/*----------------------------------------------------------------------------*/
/* PTS 1001745 UH 23-11-1998 new */

externCpp void
bd90IsObjSelfLocked (tbd_current_tree   &Current,
			         tgg92_KernelOid    &OId,
					 bool               &IsSelfLocked);    

/*----------------------------------------------------------------------------*/

externCpp void
bd90LockObj (tbd_current_tree       &Current,
			 tgg92_KernelOid        &OId,
			 tgg91_PageRef           WantedObjObjVers);    

// NOTE! if this function returns e_wait_for_lock_release then wait outside bd-locking 
    
/*----------------------------------------------------------------------------*/

/* PTS 1109298 UH 2001-01-26 new */    
externCpp void
bd90LockUpdObj (tbd_current_tree       &Current,
			    tgg92_KernelOid        &OId,
			    tgg91_PageRef           WantedObjObjVers);    


/*----------------------------------------------------------------------------*/

externCpp void 
bd90NewObj (tbd_current_tree        &Current,                  // [in\out]
            tsp00_Int4              &FrameLen,                 // [out]
            tsp00_Int4               KeyLen,                   // [in]
            void                    *pKey,                     // [in]
            tgg92_KernelOid         &ResultOId,                // [out]
            tgg91_PageRef           &ResultObjVers);           // [out]

/*----------------------------------------------------------------------------*/

externCpp void
bd90NextObjConsistentOnThisPage  (tbd_current_tree        &Current,
                                  tgg92_KernelOid         &OId,
                                  tgg91_PageRef           &ResultObjVers,
                                  tgg91_PageRef           &ObjHistRef,               // PTS 1125316 FF
                                  bool                     bWithObject,
                                  tsp00_Int4               ExtObjBodySize,
                                  void                    *pExtObjBody,
                                  cbd910_PrimObjDataNode  &NptrsPage,
                                  tsp00_Int4              &ObjBodySize,             //[out=length of the object]
                                  tsp00_Bool              &bNextObjIsFound,
                                  tsp00_Int4              &LogReadAccessesPerPage); //[out] PTS 1107819 AK 12/09/2000
 
/*----------------------------------------------------------------------------*/
externCpp void 
bd90NextObjConsistent (tbd_current_tree       &Current,
					   tgg92_KernelOid        &OId,
					   bool                    bWithObject,
					   tsp00_Int4              ExtObjBodySize,
					   void                   *pExtObjBody, 
					   tsp00_Int4             &ObjBodySize,          // [out=length of the object] 
					   tgg91_PageRef          &ObjVers,
					   tsp00_Int4             &AllLogReadAccesses);  // [out] PTS 1107819 AK 12/09/2000

// NOTE! if this function returns e_wait_for_lock_release then wait outside bd-locking 

/*!***************************************************************************
function   : bd90NextOidsConsistent
description: see kb04NextOidsConsistent
new function: PTS 1120478 
*****************************************************************************/
externCpp void
bd90NextOidsConsistent (tbd_current_tree       &Current,
                        const tgg92_KernelOid  &CurrOid,
                        tsp00_Int4             &noOfOid,
                        tgg92_KernelOid        *pOid,
                        tgg91_PageRef          *pObjVers,
                        tsp00_Int4             &AllLogReadAccesses);  

/*!---------------------------------------------------------------------------
function    : bd90NextObjFromKeyIterator
description : see kb04NextObjFromKeyIterator
Interface changed: PTS 1119480 
----------------------------------------------------------------------------*/
externCpp void
bd90NextObjFromKeyIterator (tgg00_TransContext          &Trans,
                            LVC_AbstractObjKeyIterator  &pKeyIterator,    
                            bool                         bInclusive,  
                            tsp00_Int4                   KeyLen,   
                            tsp00_Int4                   objBodySize,
                            void                        *pRestartKey,
                            tsp00_Int4                  &noOfOid,
                            tgg92_KernelOid             *pOid,
                            tgg91_PageRef               *pResultObjVers,
                            tsp00_Int4                  &LogReadAccesses,
                            tsp00_MoveObj               *pObjBody);

/*!---------------------------------------------------------------------------
function    : bd90NextObjFromKeyIterator
description : see kb04NextObjFromKeyIterator
New function since: PTS 1119480 
----------------------------------------------------------------------------*/
externCpp void
bd90PrevObjFromKeyIterator (tgg00_TransContext          &Trans,
                            LVC_AbstractObjKeyIterator  &pKeyIterator,    
                            bool                         bInclusive,  
                            tsp00_Int4                   KeyLen,   
                            tsp00_Int4                   objBodySize,
                            void                        *pRestartKey, 
                            tsp00_Int4                  &noOfOid,
                            tgg92_KernelOid             *pResultOId, 
                            tgg91_PageRef               *pResultObjVers,
                            tsp00_Int4                  &LogReadAccesses,
                            tsp00_MoveObj               *pObjBody);

/*---------------------------------------------------------------------------*/

externC tsp00_Int4 
bd90MaxNumChainsPerContainer ();

/*---------------------------------------------------------------------------*/

externCpp void 
bd90ReadAhead (tbd_current_tree  &Current);

/*---------------------------------------------------------------------------*/

externC void
bd90ReleaseObjFile (tbd_current_tree &Current);
   
/*----------------------------------------------------------------------------*/

externC void
bd90RemoveObjFile (tgg00_TransContext &Trans,
                   tgg00_ObjFileNo     ObjFileNo);

/*----------------------------------------------------------------------------*/

externCpp void
bd90MakeObjCountPersistent (tgg00_TransContext &Trans);

/*----------------------------------------------------------------------------*/

externCpp void
bd90ReuseObj (tbd_current_tree   &Current,
              tgg92_KernelOid    &OId,
              tgg91_PageRef      &ResultObjVers,
              tsp00_Int4          KeySize,
              void               *pKey,
              bool               &bTryAgain);

// NOTE! if this function returns e_wait_for_lock_release then wait outside bd-locking 

/*---------------------------------------------------------------------------*/

externCpp void 
bd90RollbackObj (tbd_current_tree     &Current,            //[inp\out]
                 tgg00_MessType_Enum   RollbackType,       //[inp]
                 tgg92_KernelOid      &OId,                //[inp]
				 const tgg00_ObjFileNo ObjFileNo,          //[inp]  //PTS 1109582 AK 09/03/2001
                 tgg00_ObjState        NewState,           //[inp]
                 tgg91_PageRef         BeforeObjRef,       //[inp]
                 tgg91_TransNo         BeforeObjUpdVers,   //[inp]
                 tsp00_Int4            BeforeObjSize,      //[inp]
                 void                 *pBeforeObj);        //[inp]

/*----------------------------------------------------------------------------*/

externCpp void
bd90UnlockObj (tbd_current_tree       &Current,
			   tgg92_KernelOid        &OId);    

/*!***************************************************************************
function   : bd90UpdateObj

description: Replaces the current image of an object by a new one

arguments  : Current          [in/out]  handle of the task context and the fileid
             OId              [in]      OId of the frame containing the object to be updated
             ObjVers          [in/out]  Version of the object which shall be updated. Only if the given Version corresponds to the
                                        Version of the current image of the object the object can be updated otherwise the error 
                                        e_object_dirty is returned
								    	After this operation ObjVers contains the version of the updated object image
             NewObjBodyLen    [in]     Length of the new object image replacing the old image of the object
             pNewObjBody       [in]     Pointer to the new object image
			 RedoEntrySequence [in]     if RedoEntrySequence is invalid this update is a normal (online) update
			                            but if it has a valid value this is a rollforward of an update operation during a restart 
										which differs from a normal update by a fact that no history data is written and 
										by a differnt check whether the update is allowed
             RedoUpdTransNo    [in]     in case that that the operation is a rollforward of an update this is 
			                            update transno of the transaction which originally updated the object othwerwise
										this parameter has no meaning
******************************************************************************/

externCpp  void 
bd90UpdateObj (tbd_current_tree         &Current,
               tgg92_KernelOid          &OId,
               tgg91_PageRef            &ObjVers,
			   tsp00_Int4                NewObjBodyLen,
               void                     *pNewObjBody,
			   const Log_EntrySequence  &RedoEntrySequence,
			   const tgg91_TransNo      &RedoUpdTransNo);

/*---------------------------------------------------------------------------*/

externCpp void
bd90DumpObjFileDir (tgg00_VfFileref      &HostFile,
					tsp00_Int4            BufferSize,
					tsp00_Page           &Buffer,
					tsp00_Int4           &OutPno,
					tsp00_Int4           &OutPos,
					tsp00_VfReturn       &HostError,
					tsp00_ErrText        &ErrText);

#endif /* HBD90_H */
