/*! 
  -----------------------------------------------------------------------------
 
  module: hcn51.h
 
  -----------------------------------------------------------------------------
 
  responsible:  BerndV
 
  special area: DBMServer Configuration Value Class
   
  description:  DBMServer Configuration Value Class - Specification

  version:      7.2.

  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/

#ifndef _HCN51_H_
#define _HCN51_H_

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
#include "gsp00.h"
#include "geo200.h"

/*
  -----------------------------------------------------------------------------
  public macros
  -----------------------------------------------------------------------------
 */
#define CFG_PARAMLOGON_CN51 (*(tsp00_Namec *) _T("SAPDB0"  ))
#define CFG_DBMUSR_CN51     (*(tsp00_Namec *) _T("SAPDB1"  ))
#define CFG_DBMPWD_CN51     (*(tsp00_Namec *) _T("SAPDB2"  ))
#define CFG_SYSUSR_CN51     (*(tsp00_Namec *) _T("SAPDB3"  ))
#define CFG_SYSPWD_CN51     (*(tsp00_Namec *) _T("SAPDB4"  ))
//#define CFG_DBAUSR_CN51     (*(tsp00_Namec *) _T("SAPDB5"  ))
#define CFG_DBAPWD_CN51     (*(tsp00_Namec *) _T("SAPDB6"  ))
#define CFG_SQLUSR_CN51     (*(tsp00_Namec *) _T("SAPDB7"  ))
#define CFG_SQLPWD_CN51     (*(tsp00_Namec *) _T("SAPDB8"  ))
#define CFG_DOMUSR_CN51     (*(tsp00_Namec *) _T("SAPDB10" ))
#define CFG_DOMPWD_CN51     (*(tsp00_Namec *) _T("SAPDB11" ))
//#define CFG_COLDUSR_CN51    (*(tsp00_Namec *) _T("SAPDB12" ))
#define CFG_DBADTL_CN51     (*(tsp00_Namec *) _T("DBADTL"  ))
#define CFG_XLOAD_CN51      (*(tsp00_Namec *) _T("XLOAD"   ))
#define CFG_PYTHON_CN51     (*(tsp00_Namec *) _T("PYTHON"  ))
#define CFG_AUTOSSAVE_CN51  (*(tsp00_Namec *) _T("AUTOSAVE"))
#define CFG_AUTOEXTFLAG_CN51 (*(tsp00_Namec *) _T("AutoExtFlag"))
#define CFG_RUNDISPATCHERFLAG_CN51 (*(tsp00_Namec *) _T("RunEventDispatcher"))

/*
  -----------------------------------------------------------------------------
  forward declaration
  -----------------------------------------------------------------------------
 */
class tcn51ConfigEntry;

/*!
  -----------------------------------------------------------------------------
  Class:        cn51DBMConfigValue
  -----------------------------------------------------------------------------

  description:  Configuration Value

                An instance of this class represents an configuration value
                of the DBM. The assigment operator stores the value persistent
                on the hard disk. For reading the value use the casting operator
                for an assignment to variables of type long or char *.
                
  -----------------------------------------------------------------------------
 */
class cn51DBMConfigValue
{
  public:
    /*!  
      Chapter: Construction and destruction of class
     */

    /*!
      -------------------------------------------------------------------------
      function:     cn51DBMConfigValue
      -------------------------------------------------------------------------
      description:  Constructor

                    Reads the value of this to the name 

      arguments:    szValueName [IN] - the name if the value
                    szDBName    [IN] - the name of the database, all values
                                       will be stored individually for
                                       a database
                                       
      -------------------------------------------------------------------------
     */
    cn51DBMConfigValue ( const tsp00_DbNamec szDbName, const tsp00_Namec szValueName );
    /*!  
      EndChapter: Construction and destruction of class
     */

    /*!  
      Chapter: Writing values
     */

    /*!
      -------------------------------------------------------------------------
      function:     operator = (tsp00_Int4)
      -------------------------------------------------------------------------
      description:  Assignment operator for tsp00_Int4
      
                    This assignment operator is used for data source of type
                    "tsp00_Int4". The value is immediately stored on disk.
                    The value will be stored in crypted representation.

      arguments:    cfgValue [IN] - the new value as long

      return value: the object itself
      -------------------------------------------------------------------------
     */
    cn51DBMConfigValue operator =            (const tsp00_Int4 cfgValue  );

    /*!
      -------------------------------------------------------------------------
      function:     operator = (tsp00_Namec)
      -------------------------------------------------------------------------
      description:  Assignment operator for "tsp00_Namec"
      
                    This assignment operator is used for data source of type
                    "tsp00_Namec". The value is immediately stored on disk
                    The value will be stored in crypted representation.

      arguments:    cfgValue [IN] - the new value as zero terminated string

      return value: the object itself
      -------------------------------------------------------------------------
     */
    cn51DBMConfigValue operator =            (const tsp00_Namec cfgValue );

    /*!
      -------------------------------------------------------------------------
      function:     operator = (tsp00_C512c)
      -------------------------------------------------------------------------
      description:  Assignment operator for "tsp00_C512c"
      
                    This assignment operator is used for data source of type
                    "tsp00_C512c". The value is immediately stored on disk
                    The value will be stored in clear representation.

      arguments:    cfgValue [IN] - the new value as zero terminated string

      return value: the object itself
      -------------------------------------------------------------------------
     */
    cn51DBMConfigValue operator =            (const tsp00_C512c cfgValue );


    /*!  
      EndChapter: Writing values
     */

    /*!  
      Chapter: Reading values
     */

    /*!
      -------------------------------------------------------------------------
      function:     operator tsp00_Int4
      -------------------------------------------------------------------------
      description:  Casting operator for tsp00_Int4
      
                    This operator provide the value as an Object of type "tsp00_Int4".
                    The value will be read from the disk!
      -------------------------------------------------------------------------
     */
    operator tsp00_Int4   ( );

    /*!
      -------------------------------------------------------------------------
      function:     operator tsp00_NameC
      -------------------------------------------------------------------------
      description:  Casting operator for tsp00_NameC
      
                    This operator provide the value as an Object of type "tsp00_NameC".
                    The value will be read from the disk!
      -------------------------------------------------------------------------
     */
    operator tsp00_Namec ( );

    /*!
      -------------------------------------------------------------------------
      function:     operator tsp00_C512c
      -------------------------------------------------------------------------
      description:  Casting operator for tsp00_C512c
      
                    This operator provide the value as an Object of type "tsp00_C512c".
                    The value will be read from the disk!
      -------------------------------------------------------------------------
     */
    operator tsp00_C512c ( );

    /*!  
      EndChapter: Reading values
     */

     /*!  
      Chapter: Error handling
     */

    /*!
      -------------------------------------------------------------------------
      function:     LastEvent
      -------------------------------------------------------------------------
      description:  returns the last error message

      return value: the event object
      -------------------------------------------------------------------------
     */
    const teo200_EventList & LastEvent( ){ return m_LastEvent;}

     /*!  
      EndChapter: Error handling
     */

    /*!  
      Chapter: Buffered work
     */

    /*!
      -------------------------------------------------------------------------
      function:     startBuffering
      -------------------------------------------------------------------------
      description:  starts buffering of config file
      
                    Via this static member you can switch in a buffered mode.
                    The whole config file will be buffered in memory for
                    subsequent creation and use of this class.

      arguments:    szDBName    [IN] - the name of the database, all values
                                       will be stored individually for
                                       a database
      -------------------------------------------------------------------------
     */
       static void startBuffering ( const tsp00_DbNamec szDbName );

    /*!
      -------------------------------------------------------------------------
      function:     stopBuffering
      -------------------------------------------------------------------------
      description:  stops buffering of config file
      
                    Via this static member you can stop the buffered mode.
                    The file will be written to disk and no longer present
                    in memory.

      arguments:    szDBName    [IN] - the name of the database, all values
                                       will be stored individually for
                                       a database
      -------------------------------------------------------------------------
     */
       static void endBuffering   ( const tsp00_DbNamec szDbName );

    /*!  
      EndChapter: Buffered work
     */

  protected:
    tsp00_DbNamec    m_szDbName;
    tsp00_Namec      m_szName;
    tsp00_C512c      m_szValue;

    void saveValue ( const tsp00_DbNamec   szDbName,
                     const tsp00_Namec     szName, 
                     const tsp00_C512c     szValue ) const;

    void readValue ( const tsp00_DbNamec   szDbName,
                     const tsp00_Namec     szName, 
                           tsp00_C512c   & szValue ) const;
   

    static tcn51ConfigEntry * readFile ( const tsp00_DbNamec      szDbName );
    static void               saveFile ( const tsp00_DbNamec      szDbName,
                                               tcn51ConfigEntry * pAnchor  );

    static tcn51ConfigEntry * m_pAnchor;
    static teo200_EventList   m_LastEvent;
};

/*! EndClass: cn51DBMConfigValue */

#endif /* _HCN51_H_ */

