/* @lastChanged: "1999-09-14  18:13"

  * @filename:   hgg10
  * @purpose:    "ConfigurationParameter"
  *
  * @release:    7.1.0.0
  * @see:        ""
  *
  * @copyright:  (c) 1998-2004 SAP AG"


    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#ifndef HGG10_H
#define HGG10_H

/* ================================================================================ */
/* ==========                   INCLUDES                                 ========== */
/* ================================================================================ */

#include "gsp00.h"
#include "ggg00.h"

externC
int g10fil_err_handling (
           const char       *ModId,
           tsp00_Int4        ModNum,
           tsp00_Int4        Size,
           tsp00_Int4        BufferPos,
           tsp00_Int4        Length,
           tgg00_BasisError *Error);

externC
int g10mv_err_handling (
           const char        *ModId,
           tsp00_Int4         ModNum,
           tsp00_Int4         SourceUpBound,
           tsp00_Int4         DestUpBound,
           tsp00_Int4         SourcePos,
           tsp00_Int4         DestPos,
           tsp00_Int4         Length,
           tgg00_BasisError  *Error);

externC 
void g10mvb (
           const char         * mod_id, 
           tsp00_Int4           mod_num,
           tsp00_Int4           source_upb, 
           tsp00_Int4           dest_upb,  
           tsp00_Page           & source,
           tsp00_Int4           src_pos, 
           tsp00_Page           & destin, 
           tsp00_Int4           dest_pos, 
           tsp00_Int4           length,
           tgg00_BasisError  & e);

externC 
void g10filuni ( 
           const char       * mod_id, 
           tsp00_Int4           mod_num,
           tsp00_Int4           obj_upb, 
           void             * obj, 
           tsp00_Int4           obj_pos, 
           tsp00_Int4           length,
           const char       * fillchar, 
           tgg00_BasisError    & e);

/* ================================================================================ */
/* ==========                   EXPORT FUNCTION DECLARATION              ========== */
/* ================================================================================ */

/* -----------------------------------------------------------------------------------*/

inline void 
g10fil (const char      *ModId,
       tsp00_Int4        ModNum,
       tsp00_Int4        BufferUpBound,
       void             *Buffer,
       tsp00_Int4        BufferPos,
	     tsp00_Int4        Length,
       char              FillChar,
       tgg00_BasisError &Error)
{
  if (Error != e_move_error)
  {
    if (BufferUpBound < BufferPos + Length - 1 || BufferPos < 0 || Length < 0) /* LINE@ 255 */
    {
      g10fil_err_handling (ModId, ModNum, BufferUpBound, BufferPos,
        Length, &Error);
    }
    else
	{
#if defined(WIN32)
		memset ( reinterpret_cast<unsigned char*>(Buffer) + BufferPos - 1, (unsigned char)FillChar, Length );
#else
		unsigned char *pBuf = (unsigned char *)Buffer;
		pBuf += (BufferPos - 1);
		memset ( pBuf, (unsigned char)FillChar, Length );
#endif
	}
  }
}


/* -----------------------------------------------------------------------------------*/

inline void 
g10mv (const char       *ModId,
       tsp00_Int4        ModNum,
       tsp00_Int4        SourceUpBound,
       tsp00_Int4        DestUpBound,
       const void       *Source,
       tsp00_Int4        SourcePos,
       void             *Destination,
       tsp00_Int4        DestinationPos,
	   tsp00_Int4        Length,
       tgg00_BasisError &Error)
{
  if (Error != e_move_error)
  {
    if (SourceUpBound < SourcePos + Length - 1 || DestUpBound < DestinationPos + Length - 1 || Length < 0 || SourcePos <= 0 || DestinationPos <= 0) /* LINE@ 481 */
    {
      g10mv_err_handling (ModId, ModNum, SourceUpBound, DestUpBound, 
        SourcePos, DestinationPos, Length, &Error);
    }
    else
	{
#if defined(WIN32)
      memcpy ( reinterpret_cast<unsigned char*>(Destination) - 1 + DestinationPos, 
        reinterpret_cast<const unsigned char*>(Source) - 1 + SourcePos, Length );
#else
	  unsigned char *pDest       = (unsigned char *)Destination;
	  const unsigned char *pSrc  = (unsigned char *)Source;
	  pDest += DestinationPos - 1;
	  pSrc  += SourcePos      - 1;
	  memcpy(pDest, pSrc, Length);
#endif
	}
  }
}

/* -----------------------------------------------------------------------------------*/

inline void 
g10mv1 (const char       *ModId,
       tsp00_Int4        ModNum,
       tsp00_Int4        SourceUpBound,
       tsp00_Int4        DestUpBound,
       const void       *Source,
       tsp00_Int4        SourcePos,
       void             *Destination,
       tsp00_Int4        DestinationPos,
	   tsp00_Int4        Length,
       tgg00_BasisError &Error)
{
  if (Error != e_move_error)
  {
    if (SourceUpBound < SourcePos + Length - 1 || DestUpBound < DestinationPos + Length - 1 || Length < 0 || SourcePos <= 0 || DestinationPos <= 0) /* LINE@ 481 */
    {
      g10mv_err_handling (ModId, ModNum, SourceUpBound, DestUpBound, 
        SourcePos, DestinationPos, Length, &Error);
    }
    else
	{
#if defined(WIN32)
      memcpy ( reinterpret_cast<unsigned char*>(Destination) - 1 + DestinationPos, 
        reinterpret_cast<const unsigned char*>(Source) - 1 + SourcePos, Length );
#else
	  unsigned char *pDest       = (unsigned char *)Destination;
	  const unsigned char *pSrc  = (unsigned char *)Source;
	  pDest += DestinationPos - 1;
	  pSrc  += SourcePos      - 1;
	  memcpy(pDest, pSrc, Length);
#endif
	}
  }
}

#endif /* HGG10_H */