/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp001.Part;
import com.sap.dbtech.vsp001.PartAttributes;

/**
 *
 */
public class DataPartBase
    extends com.sap.dbtech.util.MemIndirection
{
    final private static int maxArgCount = Short.MAX_VALUE;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;
    /**
     * DataPartBase constructor comment.
     * @param rawMem com.sap.dbtech.util.StructuredMem
     */
    DataPartBase(
        StructuredMem rawMem,
        RequestPacket requestPacket)
    {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }
    /**
     *
     * @param pos int
     * @param len int
     */
    public void addArg (
        int pos,
        int len)
    {
        ++this.argCount;
        this.extent = Math.max (this.extent, pos + len);
    }
    /**
     *
     */
    public void close ()
    {
        int argCountOffs = -Part.Data_O + Part.ArgCount_O;
        this.originalMem.putInt2 (this.argCount, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }
    /**
     *
     */
    public void closeArrayPart (
        int rows)
    {
        int argCountOffs = -Part.Data_O + Part.ArgCount_O;
        this.originalMem.putInt2 (rows, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent * rows, rows);
    }
    
    
    protected int getMaxDataSize() {
		return this.size() - this.extent  -8;
	}
    /**
     *
     * @return boolean
     * @param recordSize int
     */
    public boolean hasRoomFor (
        int recordSize,
        int reserve)
    {
        return ( this.argCount < maxArgCount
                 && (this.size () - this.extent) > (recordSize + reserve)
                );
    }
    /**
     *
     * @return boolean
     * @param recordSize int
     */
    public boolean hasRoomFor (
        int recordSize)
    {
        return ( this.argCount < maxArgCount
                 && (this.size () - this.extent) > recordSize
                );
    }
    /**
     *
     * @param pos int
     * @param len int
     */
    public void putNull (
        int pos,
        int len)
    {
        this.putInt1 (-1, pos -1);
        this.putBytes (new byte [len], pos);
        this.addArg (pos, len);
    }
    /**
     *
     */
    public int getExtent ()
    {
        return this.extent;
    }
    /**
     *
     *
     */
    public void setFirstPart () {
        this.requestPacket.addPartAttribute (PartAttributes.FirstPacket_E);
        if (false) {
            int attrOffs = -Part.Data_O + Part.Attributes_O;
            int partAttributes;

            partAttributes = this.originalMem.getInt1 (attrOffs);
            partAttributes |= PartAttributes.FirstPacket_E;
            this.originalMem.putInt1 (attrOffs, partAttributes);
        }
    }
    /**
     *
     *
     */
    public void setLastPart () {
        this.requestPacket.addPartAttribute (PartAttributes.LastPacket_E);
        if (false) {
            int attrOffs = -Part.Data_O + Part.Attributes_O;
            int partAttributes;

            partAttributes = this.originalMem.getInt1 (attrOffs);
            partAttributes |= PartAttributes.LastPacket_E;
            this.originalMem.putInt1 (attrOffs, partAttributes);
        }
    }
    /**
     *
     */
    public void
    moveRecordBase ()
    {
        this.moveBase (this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }

    
}
